/******************************************************************************
 * mod_uploader / ApachePostReader.cpp
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ApachePostReader.h 570 2005-09-02 21:21:36Z svn $
 *****************************************************************************/

#ifndef APACHEPOSTREADER_H
#define APACHEPOSTREADER_H

#include "PostReader.h"

#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#include "http_request.h"
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION

#include "apr.h"
#include "apr_buckets.h"

#undef strtoul

#include <cstdlib>

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

using namespace std;

/**
 * @brief Apache Ǥ POST ꥯȤɤ߹९饹
 */
class ApachePostReader : public PostReader
{
public:
    ApachePostReader(apr_size_t block_size, request_rec *r);
    void read(char *buffer, apr_size_t size, apr_size_t *read_size);
private:
    request_rec *request_;
    apr_bucket_brigade *brigade_;
    apr_bucket *bucket_;
    bool is_eos_;

    void get_brigade();
};

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
