/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BBSConfigReader.cpp 1773 2006-10-09 01:27:02Z svn $
 *****************************************************************************/

#include "Environment.h"

#include "apr_tables.h"

#include "BBSConfigReader.h"
#include "ConfigReader.h"
#include "BBSConfig.h"
#include "Message.h"
#include "Macro.h"
#include "SourceInfo.h"

SOURCE_INFO_ADD("$Id: BBSConfigReader.cpp 1773 2006-10-09 01:27:02Z svn $");

#define AS_TABLE_ENTRY(pointer)     reinterpret_cast<apr_table_entry_t *>(pointer)

/******************************************************************************
 * public メソッド
 *****************************************************************************/
BBSConfig *BBSConfigReader::read(apr_pool_t *pool, const char *conf_file_path)
{
    BBSConfig *config;
    apr_table_t *conf_table;
    apr_table_entry_t *conf_entry;

    config = new BBSConfig(pool);

    conf_table = ConfigReader::read(pool, conf_file_path);
    conf_entry = AS_TABLE_ENTRY(apr_table_elts(conf_table)->elts);

    for (int i = 0; i < apr_table_elts(conf_table)->nelts; i++) {
        if (strcmp(conf_entry[i].key,
                   BBSConfig::BASE_URL.param) == 0) {
            config->base_url = conf_entry[i].val;
        } else if (strcmp(conf_entry[i].key,
                   BBSConfig::DATA_DIRECTORY.param) == 0) {
            config->data_dir_path = conf_entry[i].val;
        } else if (strcmp(conf_entry[i].key,
                          BBSConfig::TEMP_DIRECTORY.param) == 0) {
            config->temp_dir_path = conf_entry[i].val;
        } else if (strcmp(conf_entry[i].key,
                          BBSConfig::INDEX_VIEW_TEMPLATE.param) == 0) {
            config->set_template(BBSConfig::INDEX_VIEW, conf_entry[i].val);
        } else if (strcmp(conf_entry[i].key,
                          BBSConfig::COMMENT_VIEW_TEMPLATE.param) == 0) {
            config->set_template(BBSConfig::COMMENT_VIEW, conf_entry[i].val);
        } else if (strcmp(conf_entry[i].key,
                          BBSConfig::THREAD_VIEW_TEMPLATE.param) == 0) {
            config->set_template(BBSConfig::THREAD_VIEW, conf_entry[i].val);
        } else {
            THROW(MESSAGE_CONF_PARAM_INVALID);
        }
    }

    return config;
}


/******************************************************************************
 * テスト
 *****************************************************************************/
#ifdef DEBUG_BBSConfigReader

#include "TestRunner.h"

void show_usage(const char *prog_name)
{
    cerr << "Usage: " << prog_name << " <CONF_FIEL_PATH>" << endl;
}

void run_read(apr_pool_t *pool, const char *conf_file_path)
{
    show_test_name("read");

    BBSConfigReader::read(pool, conf_file_path);
}

void run_all(apr_pool_t *pool, int argc, const char * const *argv)
{
    const char *conf_file_path;

    if (argc != 2) {
        THROW(MESSAGE_ARGUMENT_INVALID);
    }

    conf_file_path = argv[1];

    if (!is_exist(pool, conf_file_path)) {
        THROW(MESSAGE_CONF_FILE_NOT_FOUND);
    }

    show_line();
    run_read(pool, conf_file_path);
}

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
