/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: MmapCommentIterator.h 1565 2006-09-21 15:56:18Z svn $
 *****************************************************************************/

#ifndef MMAP_COMMENT_ITERATOR_H
#define MMAP_COMMENT_ITERATOR_H

#include "Environment.h"

#include "BBSCommentIterator.h"
#include "File.h"
#include "Uncopyable.h"

using namespace std;

class BBSThread;

/**
 * @brief コメントの読み出しを行うクラス．
 *
 * コンストラクタとデストラクタで例外が発生する可能性があるので，取り扱
 * いには注意が必要です．
 */
class MmapCommentIterator: public BBSCommentIterator
{
public:
    MmapCommentIterator(BBSThread *bbs_thread,
                        File& bthread_file,
                        BBSCommentIterator::range_t *ranges=NULL,
                        apr_size_t range_count=0);

private:
    File bthread_file_;
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
