/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: BBSThreadVariableCreator.h 1945 2006-11-07 14:54:54Z svn $
 *****************************************************************************/

#ifndef BBS_THREAD_VARIABLE_CREATOR_H
#define BBS_THREAD_VARIABLE_CREATOR_H

#include "Environment.h"

#include "BBSThread.h"
#include "BBSCommentIterator.h"
#include "TemplateVariableCreator.h"
#include "TemplateVariable.h"
#include "Uncopyable.h"

using namespace std;

class BBSCommentVariableCreator;
class BBSThreadManager;
class BBSThreadList;

/**
 * @brief テンプレートの変数を生成するクラス
 */
class BBSThreadVariableCreator: public Uncopyable
{
public:
    BBSThreadVariableCreator(const char **keys);

    TemplateVariable::variable_t *create(apr_pool_t *pool,
                                         BBSCommentVariableCreator *var_creator,
                                         BBSCommentIterator *bcomment_iter,
                                         BBSThreadManager *thread_manager,
                                         BBSThread::info_t *info_list,
                                         apr_size_t info_list_size,
                                         apr_size_t comment_count) const;

    TemplateVariable::variable_t *create_info(apr_pool_t *pool,
                                              BBSThread::info_t *info_list,
                                              apr_size_t info_list_size) const;
    TemplateVariable::variable_t *create_info(apr_pool_t *pool,
                                              BBSThreadList *thread_list) const;

    static BBSThreadVariableCreator *get_instance(void *memory,
                                                  const char **keys);

private:
    typedef TemplateVariable::variable_t            variable_t;
    typedef TemplateVariable::scalar_t              scalar_t;
    typedef TemplateVariableCreator::key_index_t    key_index_t;

    typedef struct InfoKeyIndex {
        key_index_t id;
        key_index_t subject;
        key_index_t comment_count;

        InfoKeyIndex()
          : id("id"),
            subject("subject"),
            comment_count("comment_count")
        {

        }
    } info_key_index_t;

    void init();

    TemplateVariable::variable_t *create_info(apr_pool_t *pool,
                                              BBSThread::info_t *thread_info,
                                              void *var_memory,
                                              void *sca_memory) const throw();
    void set_range(BBSThread::info_t *thread_info,
                   apr_size_t comment_count,
                   BBSCommentIterator::range_t *range,
                   apr_size_t *range_count) const throw();

    apr_size_t get_thread_array_memory_size(apr_size_t list_size) const;
    apr_size_t get_info_array_memory_size(apr_size_t list_size) const;
    apr_size_t get_info_memory_size() const;

    void validate_list_size(apr_size_t *list_size, BBSThreadList *thread_list) const;

    const char **keys_;

    info_key_index_t info_index_;
    apr_size_t info_index_max_;
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
