//============================================================================
//	
//	SoftbankEncode.xs
//	
//		Softbank ʸб ʸѴ⥸塼
//	
//  ʲδؿ Perl Ѥ export 
//	
//		unicodeToEscaped
//			Unicodeʸ Softbank ʸ Unicode 򥦥֥ (Escaped
//			sequence) Ѵ롣
//					
//			SV*	unicodeToEscaped(
//				unsigned char* pText,
//				int cbText
//			);
//
//		escapedToUnicode
//			Unicodeʸ Softbank֥ (Escaped sequence) 
//			Softbank ʸ (Unicode ɽ) Ѵ롣
//
//			SV* escapedToUnicode(
//				unsigned char* pText,
//				int cbText
//			);
//
//============================================================================

#include <errno.h>
#include <wchar.h>

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

typedef unsigned short WCHAR;

#define	U_PRIVATE_USE_MIN	((WCHAR)0xe000)		/* Unicode  Private Use Area */
#define	U_PRIVATE_USE_MAX	((WCHAR)0xf8ff)		/* Unicode  Private Use Area */

//----------------------------------------------------------------------------
// Softbank ʸ Unicode ɽȥ֥ɽ (escaped sequence) 
// бơ֥
//
// : U+E001 => 1B 24 'G' '!' 0F
//
// EMOTICON_MAP* _findEmoticonFromUnicode(WCHAR wch);

typedef struct {
	WCHAR		wch;
	char*		pEncoded;
} EMOTICON_MAP;

static EMOTICON_MAP emoticonMap[] =
{
	{ 0xE001, "G!" },
	{ 0xE002, "G\"" },
	{ 0xE003, "G#" },
	{ 0xE004, "G$" },
	{ 0xE005, "G%" },
	{ 0xE006, "G&" },
	{ 0xE007, "G'" },
	{ 0xE008, "G(" },
	{ 0xE009, "G)" },
	{ 0xE00A, "G*" },
	{ 0xE00B, "G+" },
	{ 0xE00C, "G," },
	{ 0xE00D, "G-" },
	{ 0xE00E, "G." },
	{ 0xE00F, "G/" },
	{ 0xE010, "G0" },
	{ 0xE011, "G1" },
	{ 0xE012, "G2" },
	{ 0xE013, "G3" },
	{ 0xE014, "G4" },
	{ 0xE015, "G5" },
	{ 0xE016, "G6" },
	{ 0xE017, "G7" },
	{ 0xE018, "G8" },
	{ 0xE019, "G9" },
	{ 0xE01A, "G:" },
	{ 0xE01B, "G;" },
	{ 0xE01C, "G<" },
	{ 0xE01D, "G=" },
	{ 0xE01E, "G>" },
	{ 0xE01F, "G?" },
	{ 0xE020, "G@" },
	{ 0xE021, "GA" },
	{ 0xE022, "GB" },
	{ 0xE023, "GC" },
	{ 0xE024, "GD" },
	{ 0xE025, "GE" },
	{ 0xE026, "GF" },
	{ 0xE027, "GG" },
	{ 0xE028, "GH" },
	{ 0xE029, "GI" },
	{ 0xE02A, "GJ" },
	{ 0xE02B, "GK" },
	{ 0xE02C, "GL" },
	{ 0xE02D, "GM" },
	{ 0xE02E, "GN" },
	{ 0xE02F, "GO" },
	{ 0xE030, "GP" },
	{ 0xE031, "GQ" },
	{ 0xE032, "GR" },
	{ 0xE033, "GS" },
	{ 0xE034, "GT" },
	{ 0xE035, "GU" },
	{ 0xE036, "GV" },
	{ 0xE037, "GW" },
	{ 0xE038, "GX" },
	{ 0xE039, "GY" },
	{ 0xE03A, "GZ" },
	{ 0xE03B, "G[" },
	{ 0xE03C, "G\\" },
	{ 0xE03D, "G]" },
	{ 0xE03E, "G^" },
	{ 0xE03F, "G_" },
	{ 0xE040, "G`" },
	{ 0xE041, "Ga" },
	{ 0xE042, "Gb" },
	{ 0xE043, "Gc" },
	{ 0xE044, "Gd" },
	{ 0xE045, "Ge" },
	{ 0xE046, "Gf" },
	{ 0xE047, "Gg" },
	{ 0xE048, "Gh" },
	{ 0xE049, "Gi" },
	{ 0xE04A, "Gj" },
	{ 0xE04B, "Gk" },
	{ 0xE04C, "Gl" },
	{ 0xE04D, "Gm" },
	{ 0xE04E, "Gn" },
	{ 0xE04F, "Go" },
	{ 0xE050, "Gp" },
	{ 0xE051, "Gq" },
	{ 0xE052, "Gr" },
	{ 0xE053, "Gs" },
	{ 0xE054, "Gt" },
	{ 0xE055, "Gu" },
	{ 0xE056, "Gv" },
	{ 0xE057, "Gw" },
	{ 0xE058, "Gx" },
	{ 0xE059, "Gy" },
	{ 0xE05A, "Gz" },
	{ 0xE101, "E!" },
	{ 0xE102, "E\"" },
	{ 0xE103, "E#" },
	{ 0xE104, "E$" },
	{ 0xE105, "E%" },
	{ 0xE106, "E&" },
	{ 0xE107, "E'" },
	{ 0xE108, "E(" },
	{ 0xE109, "E)" },
	{ 0xE10A, "E*" },
	{ 0xE10B, "E+" },
	{ 0xE10C, "E," },
	{ 0xE10D, "E-" },
	{ 0xE10E, "E." },
	{ 0xE10F, "E/" },
	{ 0xE110, "E0" },
	{ 0xE111, "E1" },
	{ 0xE112, "E2" },
	{ 0xE113, "E3" },
	{ 0xE114, "E4" },
	{ 0xE115, "E5" },
	{ 0xE116, "E6" },
	{ 0xE117, "E7" },
	{ 0xE118, "E8" },
	{ 0xE119, "E9" },
	{ 0xE11A, "E:" },
	{ 0xE11B, "E;" },
	{ 0xE11C, "E<" },
	{ 0xE11D, "E=" },
	{ 0xE11E, "E>" },
	{ 0xE11F, "E?" },
	{ 0xE120, "E@" },
	{ 0xE121, "EA" },
	{ 0xE122, "EB" },
	{ 0xE123, "EC" },
	{ 0xE124, "ED" },
	{ 0xE125, "EE" },
	{ 0xE126, "EF" },
	{ 0xE127, "EG" },
	{ 0xE128, "EH" },
	{ 0xE129, "EI" },
	{ 0xE12A, "EJ" },
	{ 0xE12B, "EK" },
	{ 0xE12C, "EL" },
	{ 0xE12D, "EM" },
	{ 0xE12E, "EN" },
	{ 0xE12F, "EO" },
	{ 0xE130, "EP" },
	{ 0xE131, "EQ" },
	{ 0xE132, "ER" },
	{ 0xE133, "ES" },
	{ 0xE134, "ET" },
	{ 0xE135, "EU" },
	{ 0xE136, "EV" },
	{ 0xE137, "EW" },
	{ 0xE138, "EX" },
	{ 0xE139, "EY" },
	{ 0xE13A, "EZ" },
	{ 0xE13B, "E[" },
	{ 0xE13C, "E\\" },
	{ 0xE13D, "E]" },
	{ 0xE13E, "E^" },
	{ 0xE13F, "E_" },
	{ 0xE140, "E`" },
	{ 0xE141, "Ea" },
	{ 0xE142, "Eb" },
	{ 0xE143, "Ec" },
	{ 0xE144, "Ed" },
	{ 0xE145, "Ee" },
	{ 0xE146, "Ef" },
	{ 0xE147, "Eg" },
	{ 0xE148, "Eh" },
	{ 0xE149, "Ei" },
	{ 0xE14A, "Ej" },
	{ 0xE14B, "Ek" },
	{ 0xE14C, "El" },
	{ 0xE14D, "Em" },
	{ 0xE14E, "En" },
	{ 0xE14F, "Eo" },
	{ 0xE150, "Ep" },
	{ 0xE151, "Eq" },
	{ 0xE152, "Er" },
	{ 0xE153, "Es" },
	{ 0xE154, "Et" },
	{ 0xE155, "Eu" },
	{ 0xE156, "Ev" },
	{ 0xE157, "Ew" },
	{ 0xE158, "Ex" },
	{ 0xE159, "Ey" },
	{ 0xE15A, "Ez" },
	{ 0xE201, "F!" },
	{ 0xE202, "F\"" },
	{ 0xE203, "F#" },
	{ 0xE204, "F$" },
	{ 0xE205, "F%" },
	{ 0xE206, "F&" },
	{ 0xE207, "F'" },
	{ 0xE208, "F(" },
	{ 0xE209, "F)" },
	{ 0xE20A, "F*" },
	{ 0xE20B, "F+" },
	{ 0xE20C, "F," },
	{ 0xE20D, "F-" },
	{ 0xE20E, "F." },
	{ 0xE20F, "F/" },
	{ 0xE210, "F0" },
	{ 0xE211, "F1" },
	{ 0xE212, "F2" },
	{ 0xE213, "F3" },
	{ 0xE214, "F4" },
	{ 0xE215, "F5" },
	{ 0xE216, "F6" },
	{ 0xE217, "F7" },
	{ 0xE218, "F8" },
	{ 0xE219, "F9" },
	{ 0xE21A, "F:" },
	{ 0xE21B, "F;" },
	{ 0xE21C, "F<" },
	{ 0xE21D, "F=" },
	{ 0xE21E, "F>" },
	{ 0xE21F, "F?" },
	{ 0xE220, "F@" },
	{ 0xE221, "FA" },
	{ 0xE222, "FB" },
	{ 0xE223, "FC" },
	{ 0xE224, "FD" },
	{ 0xE225, "FE" },
	{ 0xE226, "FF" },
	{ 0xE227, "FG" },
	{ 0xE228, "FH" },
	{ 0xE229, "FI" },
	{ 0xE22A, "FJ" },
	{ 0xE22B, "FK" },
	{ 0xE22C, "FL" },
	{ 0xE22D, "FM" },
	{ 0xE22E, "FN" },
	{ 0xE22F, "FO" },
	{ 0xE230, "FP" },
	{ 0xE231, "FQ" },
	{ 0xE232, "FR" },
	{ 0xE233, "FS" },
	{ 0xE234, "FT" },
	{ 0xE235, "FU" },
	{ 0xE236, "FV" },
	{ 0xE237, "FW" },
	{ 0xE238, "FX" },
	{ 0xE239, "FY" },
	{ 0xE23A, "FZ" },
	{ 0xE23B, "F[" },
	{ 0xE23C, "F\\" },
	{ 0xE23D, "F]" },
	{ 0xE23E, "F^" },
	{ 0xE23F, "F_" },
	{ 0xE240, "F`" },
	{ 0xE241, "Fa" },
	{ 0xE242, "Fb" },
	{ 0xE243, "Fc" },
	{ 0xE244, "Fd" },
	{ 0xE245, "Fe" },
	{ 0xE246, "Ff" },
	{ 0xE247, "Fg" },
	{ 0xE248, "Fh" },
	{ 0xE249, "Fi" },
	{ 0xE24A, "Fj" },
	{ 0xE24B, "Fk" },
	{ 0xE24C, "Fl" },
	{ 0xE24D, "Fm" },
	{ 0xE24E, "Fn" },
	{ 0xE24F, "Fo" },
	{ 0xE250, "Fp" },
	{ 0xE251, "Fq" },
	{ 0xE252, "Fr" },
	{ 0xE253, "Fs" },
	{ 0xE254, "Ft" },
	{ 0xE255, "Fu" },
	{ 0xE256, "Fv" },
	{ 0xE257, "Fw" },
	{ 0xE258, "Fx" },
	{ 0xE259, "Fy" },
	{ 0xE25A, "Fz" },
	{ 0xE301, "O!" },
	{ 0xE302, "O\"" },
	{ 0xE303, "O#" },
	{ 0xE304, "O$" },
	{ 0xE305, "O%" },
	{ 0xE306, "O&" },
	{ 0xE307, "O'" },
	{ 0xE308, "O(" },
	{ 0xE309, "O)" },
	{ 0xE30A, "O*" },
	{ 0xE30B, "O+" },
	{ 0xE30C, "O," },
	{ 0xE30D, "O-" },
	{ 0xE30E, "O." },
	{ 0xE30F, "O/" },
	{ 0xE310, "O0" },
	{ 0xE311, "O1" },
	{ 0xE312, "O2" },
	{ 0xE313, "O3" },
	{ 0xE314, "O4" },
	{ 0xE315, "O5" },
	{ 0xE316, "O6" },
	{ 0xE317, "O7" },
	{ 0xE318, "O8" },
	{ 0xE319, "O9" },
	{ 0xE31A, "O:" },
	{ 0xE31B, "O;" },
	{ 0xE31C, "O<" },
	{ 0xE31D, "O=" },
	{ 0xE31E, "O>" },
	{ 0xE31F, "O?" },
	{ 0xE320, "O@" },
	{ 0xE321, "OA" },
	{ 0xE322, "OB" },
	{ 0xE323, "OC" },
	{ 0xE324, "OD" },
	{ 0xE325, "OE" },
	{ 0xE326, "OF" },
	{ 0xE327, "OG" },
	{ 0xE328, "OH" },
	{ 0xE329, "OI" },
	{ 0xE32A, "OJ" },
	{ 0xE32B, "OK" },
	{ 0xE32C, "OL" },
	{ 0xE32D, "OM" },
	{ 0xE32E, "ON" },
	{ 0xE32F, "OO" },
	{ 0xE330, "OP" },
	{ 0xE331, "OQ" },
	{ 0xE332, "OR" },
	{ 0xE333, "OS" },
	{ 0xE334, "OT" },
	{ 0xE335, "OU" },
	{ 0xE336, "OV" },
	{ 0xE337, "OW" },
	{ 0xE338, "OX" },
	{ 0xE339, "OY" },
	{ 0xE33A, "OZ" },
	{ 0xE33B, "O[" },
	{ 0xE33C, "O\\" },
	{ 0xE33D, "O]" },
	{ 0xE33E, "O^" },
	{ 0xE33F, "O_" },
	{ 0xE340, "O`" },
	{ 0xE341, "Oa" },
	{ 0xE342, "Ob" },
	{ 0xE343, "Oc" },
	{ 0xE344, "Od" },
	{ 0xE345, "Oe" },
	{ 0xE346, "Of" },
	{ 0xE347, "Og" },
	{ 0xE348, "Oh" },
	{ 0xE349, "Oi" },
	{ 0xE34A, "Oj" },
	{ 0xE34B, "Ok" },
	{ 0xE34C, "Ol" },
	{ 0xE34D, "Om" },
	{ 0xE401, "P!" },
	{ 0xE402, "P\"" },
	{ 0xE403, "P#" },
	{ 0xE404, "P$" },
	{ 0xE405, "P%" },
	{ 0xE406, "P&" },
	{ 0xE407, "P'" },
	{ 0xE408, "P(" },
	{ 0xE409, "P)" },
	{ 0xE40A, "P*" },
	{ 0xE40B, "P+" },
	{ 0xE40C, "P," },
	{ 0xE40D, "P-" },
	{ 0xE40E, "P." },
	{ 0xE40F, "P/" },
	{ 0xE410, "P0" },
	{ 0xE411, "P1" },
	{ 0xE412, "P2" },
	{ 0xE413, "P3" },
	{ 0xE414, "P4" },
	{ 0xE415, "P5" },
	{ 0xE416, "P6" },
	{ 0xE417, "P7" },
	{ 0xE418, "P8" },
	{ 0xE419, "P9" },
	{ 0xE41A, "P:" },
	{ 0xE41B, "P;" },
	{ 0xE41C, "P<" },
	{ 0xE41D, "P=" },
	{ 0xE41E, "P>" },
	{ 0xE41F, "P?" },
	{ 0xE420, "P@" },
	{ 0xE421, "PA" },
	{ 0xE422, "PB" },
	{ 0xE423, "PC" },
	{ 0xE424, "PD" },
	{ 0xE425, "PE" },
	{ 0xE426, "PF" },
	{ 0xE427, "PG" },
	{ 0xE428, "PH" },
	{ 0xE429, "PI" },
	{ 0xE42A, "PJ" },
	{ 0xE42B, "PK" },
	{ 0xE42C, "PL" },
	{ 0xE42D, "PM" },
	{ 0xE42E, "PN" },
	{ 0xE42F, "PO" },
	{ 0xE430, "PP" },
	{ 0xE431, "PQ" },
	{ 0xE432, "PR" },
	{ 0xE433, "PS" },
	{ 0xE434, "PT" },
	{ 0xE435, "PU" },
	{ 0xE436, "PV" },
	{ 0xE437, "PW" },
	{ 0xE438, "PX" },
	{ 0xE439, "PY" },
	{ 0xE43A, "PZ" },
	{ 0xE43B, "P[" },
	{ 0xE43C, "P\\" },
	{ 0xE43D, "P]" },
	{ 0xE43E, "P^" },
	{ 0xE43F, "P_" },
	{ 0xE440, "P`" },
	{ 0xE441, "Pa" },
	{ 0xE442, "Pb" },
	{ 0xE443, "Pc" },
	{ 0xE444, "Pd" },
	{ 0xE445, "Pe" },
	{ 0xE446, "Pf" },
	{ 0xE447, "Pg" },
	{ 0xE448, "Ph" },
	{ 0xE449, "Pi" },
	{ 0xE44A, "Pj" },
	{ 0xE44B, "Pk" },
	{ 0xE44C, "Pl" },
	{ 0xE501, "Q!" },
	{ 0xE502, "Q\"" },
	{ 0xE503, "Q#" },
	{ 0xE504, "Q$" },
	{ 0xE505, "Q%" },
	{ 0xE506, "Q&" },
	{ 0xE507, "Q'" },
	{ 0xE508, "Q(" },
	{ 0xE509, "Q)" },
	{ 0xE50A, "Q*" },
	{ 0xE50B, "Q+" },
	{ 0xE50C, "Q," },
	{ 0xE50D, "Q-" },
	{ 0xE50E, "Q." },
	{ 0xE50F, "Q/" },
	{ 0xE510, "Q0" },
	{ 0xE511, "Q1" },
	{ 0xE512, "Q2" },
	{ 0xE513, "Q3" },
	{ 0xE514, "Q4" },
	{ 0xE515, "Q5" },
	{ 0xE516, "Q6" },
	{ 0xE517, "Q7" },
	{ 0xE518, "Q8" },
	{ 0xE519, "Q9" },
	{ 0xE51A, "Q:" },
	{ 0xE51B, "Q;" },
	{ 0xE51C, "Q<" },
	{ 0xE51D, "Q=" },
	{ 0xE51E, "Q>" },
	{ 0xE51F, "Q?" },
	{ 0xE520, "Q@" },
	{ 0xE521, "QA" },
	{ 0xE522, "QB" },
	{ 0xE523, "QC" },
	{ 0xE524, "QD" },
	{ 0xE525, "QE" },
	{ 0xE526, "QF" },
	{ 0xE527, "QG" },
	{ 0xE528, "QH" },
	{ 0xE529, "QI" },
	{ 0xE52A, "QJ" },
	{ 0xE52B, "QK" },
	{ 0xE52C, "QL" },
	{ 0xE52D, "QM" },
	{ 0xE52E, "QN" },
	{ 0xE52F, "QO" },
	{ 0xE530, "QP" },
	{ 0xE531, "QQ" },
	{ 0xE532, "QR" },
	{ 0xE533, "QS" },
	{ 0xE534, "QT" },
	{ 0xE535, "QU" },
	{ 0xE536, "QV" },
	{ 0xE537, "QW" },
	{ 0xE538, "QX" },
	{ 0xE539, "QY" },
	{ 0,      NULL }
};

static EMOTICON_MAP* _findEmoticonFromUnicode(WCHAR wch)
{
	EMOTICON_MAP* p;
	for (p = emoticonMap; p->wch != 0; p++) {
		if (p->wch == wch) {
			return p;
		}
	}
	return NULL;
}

static EMOTICON_MAP* _findEmoticonFromEscapedSequence(char ch1, char ch2)
{
	EMOTICON_MAP* p;
	for (p = emoticonMap; p->wch != 0; p++) {
		if (p->pEncoded[0] == ch1 && p->pEncoded[1] == ch2) {
			return p;
		}
	}
	return NULL;
}


MODULE = SoftbankEncode		PACKAGE = SoftbankEncode		


SV*
unicodeToEscaped(pText, cbText)
	unsigned char* pText
	int			   cbText
  CODE:
	//----------------------------------------------------------------------------
	// Softbank ʸ (Unicode)  Softbank ֥ (Escaped sequence) 
	// Ѵ
	//
	// ϥѥ᡼
	//		pText	Unicode ʸ (UTF-16LE 󥳡)
	//		cbText	Хȿ ( ʸ * 2)
	//
	// 
	//		ݤ줿 scalar value (SV*) (UTF-16LE 󥳡ʸ)

	WCHAR* pwchIn         = NULL;	// ʸ
	size_t   cchIn        = 0;		// ʸʸ
	size_t   cchInPrivate = 0;		// Private Use 󥸤ʸΥ
	WCHAR* pwchOut        = NULL;	// ϥХåե
	size_t   cchOutBuf    = 0;		// Хåե (ʸ)
	size_t   cchOut       = 0;		// ʸ
	WCHAR* pIn            = NULL;	// ѥݥ
	WCHAR* pOut           = NULL;	// ѥݥ

	cchIn  = cbText / sizeof(WCHAR);
	pwchIn = (WCHAR*) pText;

	// Private Use 󥸤ʸ

	for (pIn = pwchIn; pIn < pwchIn + cchIn; pIn++) {
		if (U_PRIVATE_USE_MIN <= *pIn && *pIn <= U_PRIVATE_USE_MAX) {
			cchInPrivate++;
		}
	}
	
	// ϥХåեݤ

	cchOutBuf = cchIn + cchInPrivate * 4 + 1;
	pwchOut   = (WCHAR*) malloc(sizeof(WCHAR) * cchOutBuf);
	pOut      = pwchOut;

	if (pwchOut && pwchIn) {

		// ʸȤ˥롼

		for (pIn = pwchIn; pIn < pwchIn + cchIn; pIn++) {
			if (U_PRIVATE_USE_MIN <= *pIn && *pIn <= U_PRIVATE_USE_MAX) {
				EMOTICON_MAP* map = _findEmoticonFromUnicode(*pIn);
				if (map) {

					// Softbank ʸ (Unicode)  "֥" (escaped sequence) Ѵ

					if (pwchOut <= pOut && pOut + 5 < pwchOut + cchOutBuf) {
						*(pOut + 0) = (WCHAR)0x1b;
						*(pOut + 1) = (WCHAR)0x24;
						*(pOut + 2) = (WCHAR)(map->pEncoded[0]);
						*(pOut + 3) = (WCHAR)(map->pEncoded[1]);
						*(pOut + 4) = (WCHAR)0x0f;
						pOut   += 5;
						cchOut += 5;
					}
				} else {

					// Private Use ʸ Softbank ʸǤϤʤΤ ΤޤѴ

					if (pwchOut <= pOut && pOut < pwchOut + cchOutBuf) {
						*pOut = *pIn;
						pOut++;
						cchOut++;
					}
				}
			} else {
			
				// Private Use ʸǤϤʤΤǤΤޤѴ
			
				if (pwchOut <= pOut && pOut < pwchOut + cchOutBuf) {
					*pOut = *pIn;
					pOut++;
					cchOut++;
				}
			}
		}
		
		// üʸɲ

		if (pwchOut <= pOut && pOut < pwchOut + cchOutBuf) {
			*pOut = (WCHAR)'\0';
		}
	}
	
	// ͤ򥻥å
	
	if (pwchOut && cchOut > 0) {
		RETVAL = newSVpv((char*)pwchOut, cchOut * sizeof(WCHAR));
	} else {
		RETVAL = newSVpv("", 0);
	}

	// ꡼󥢥å

	if (pwchOut) {
		free(pwchOut);
	}

  OUTPUT:
  	RETVAL


SV*
escapedToUnicode(pText, cbText)
	unsigned char* pText
	int			   cbText
  CODE:
	//----------------------------------------------------------------------------
	// Softbank ֥ (Escaped sequence)  Softbank ʸ (Unicode) 
	// Ѵ
	//
	// ϥѥ᡼
	//		pText	Unicode ʸ (UTF-16LE 󥳡)
	//		cbText	Хȿ ( ʸ * 2)
	//
	// 
	//		ݤ줿 scalar value (SV*) (UTF-16LE 󥳡ʸ)

	WCHAR* pwchIn         = NULL;	// ʸ
	size_t   cchIn        = 0;		// ʸʸ
	WCHAR* pwchOut        = NULL;	// ϥХåե
	size_t   cchOutBuf    = 0;		// Хåե (ʸ)
	size_t   cchOut       = 0;		// ʸ
	WCHAR* pIn            = NULL;	// ѥݥ
	WCHAR* pOut           = NULL;	// ѥݥ

	cchIn  = cbText / sizeof(WCHAR);
	pwchIn = (WCHAR*) pText;

	// ϥХåեݤ

	cchOutBuf = cchIn + 1;
	pwchOut   = (WCHAR*) malloc(sizeof(WCHAR) * cchOutBuf);
	pOut      = pwchOut;

	if (pwchOut && pwchIn) {

		// ʸȤ˥롼

		for (pIn = pwchIn; pIn < pwchIn + cchIn; pIn++) {

			if (pIn + 4 < pwchIn + cchIn &&
				pIn[0] == (WCHAR)0x1b && pIn[1] == (WCHAR)0x24 && pIn[4] == (WCHAR)0x0f) {

				char ch1 = (char)pIn[2];
				char ch2 = (char)pIn[3];

				// Escaped sequence Ǥ '\x5c' ('\\')  U+00A5 ̤
				if (pIn[2] == 0x00a5 /* U+00A5 YEN SIGN */) {
					ch1 = '\x5c'; // U+005C REVERSE SOLIDUS (Backslash)
				}
				if (pIn[3] == 0x00a5 /* U+00A5 YEN SIGN */) {
					ch2 = '\x5c'; // U+005C REVERSE SOLIDUS (Backslash)
				}

				EMOTICON_MAP* map = _findEmoticonFromEscapedSequence(ch1, ch2);
				if (map) {

					// "֥" (Escaped sequence) Softbank ʸ (Unicode) Ѵ

					if (pwchOut <= pOut && pOut < pwchOut + cchOutBuf) {
						*pOut = map->wch;
						pOut++;
						cchOut++;
					}
					pIn += 4;

				} else {

					// Escaped sequence Τ褦Ѵơ֥˸ĤʤΤ Τޤ޽

					if (pwchOut <= pOut && pOut < pwchOut + cchOutBuf) {
						*pOut = *pIn;
						pOut++;
						cchOut++;
					}
				}

			} else {
			
				// Escaped sequence ǤϤʤΤǤΤޤѴ
				
				if (pwchOut <= pOut && pOut < pwchOut + cchOutBuf) {
					*pOut = *pIn;
					pOut++;
					cchOut++;
				}
			}
		}
		
		// üʸɲ

		if (pwchOut <= pOut && pOut < pwchOut + cchOutBuf) {
			*pOut = (WCHAR)'\0';
		}
	}
	
	// ͤ򥻥å
	
	if (pwchOut && cchOut > 0) {
		RETVAL = newSVpv((char*)pwchOut, cchOut * sizeof(WCHAR));
	} else {
		RETVAL = newSVpv("", 0);
	}

	// ꡼󥢥å

	if (pwchOut) {
		free(pwchOut);
	}

  OUTPUT:
  	RETVAL
