package DA;

=pod
----------------------------------------------------------------------
DB ϥɥ³⥸塼

ʣ DB ϥɥα³³뤿˻ѡ
ҤȤĤΥơ֥ʣ DB ʬ䤹ʤɤϡ
оݤΥϥɥ뤿δؿ򤳤ɲä롣
----------------------------------------------------------------------
=cut

use strict;
use DBI;
use MobaConf;
use MException;
use MLog;

our %CONF; # DB main.conf 饻åȤ

our %DBH; #  DB ϥɥ
our %USE; #  DB ϥɥ

our $CONNECT_TIMEOUT = 10;

#-----------------------------------------------------------
# ˽äƥϥɥʥϥɥϥå夵

# IN:  ̾
# RET: DBϥɥ(DBI::db object)

sub getHandle {
	my $name = shift;
	
	if (!$CONF{$name}) {
		MException::error("no database configuration for $name",
			{ CODE => 4001 } );
	}
	
	my $do_connect = 1;
	
	if ($DBH{$name}) {
		$do_connect = 0;
		if (!$USE{$name}) {
			# DA::reset 塢Ѥʤ³ǧ
			if (!$DBH{$name}->ping) {
				$do_connect = 1;
				$DBH{$name}->disconnect();
				delete($DBH{$name});
			}
		}
	}
	if ($do_connect) {
		$DBH{$name} = _connect($name);
	}
	$USE{$name} = 1;
	return($DBH{$name});
}
sub _connect {
	my $name = shift;
	
	my $ac = $CONF{$name}->{TX} ? 0 : 1;
	
	my $dbh = DBI->connect(
		"dbi:mysql:dbname=$CONF{$name}->{DB}".
		";host=$CONF{$name}->{HOST}".
		";mysql_connect_timeout=$CONNECT_TIMEOUT",
		
		"$CONF{$name}->{USER}", "$CONF{$name}->{PASS}",
		{ RaiseError => 1, PrintError => 0, AutoCommit => $ac, Warn => 0 });
	if (!$dbh) {
		MException::error("connect failed",
			{ CODE => 4002, DBIERR => $DBI::err, MSG => $DBI::errstr });
	}
	if (!$ac && $dbh->{AutoCommit}) {
		MException::error("can't set AutoCommit=0",
			{ CODE => 4002, DBIERR => $DBI::err, MSG => $DBI::errstr });
	}
	$dbh->{mysql_auto_reconnect}    = 0;
	$dbh->{mysql_client_found_rows} = 1;
	eval { $dbh->do('set names binary'); };
	
	return $dbh;
}

#-----------------------------------------------------------
# ȥ󥶥󳫻˼¹

sub reset {
	%USE = ();
}

# ³³ƤϥɥϡַвǤƤ礬롣
# reset ϡΤ褦ʥϥɥФƣ٤³Ĥ롣
# ȥ󥶥Ǽ¹Ԥȡ
#   Ѥߥϥɥ뤬̤ commit Τޤ޻ե饰ƤޤΤա

#-----------------------------------------------------------
# ³ DB ϥɥ

#  dbh ϤȡñΤǤǤǽ

sub disconnect {
	my $tgt_dbh = shift;
	
	my @err;
	for my $name (keys(%USE)) {
		my $dbh = $DBH{$name};
		next if ($tgt_dbh && $tgt_dbh ne $dbh);
		eval {
			$dbh->disconnect();
			delete($DBH{$name});
		};
		push(@err, $name) if ($@);
	}
	if (scalar(@err)) {
		die "error: ". join(',', @err);
	}
	%USE = ();
}

#-----------------------------------------------------------
# ³ DB ϥɥǡRELEASE ե饰դΤߡ

sub release {
	my $tgt_dbh = shift;
	
	my @err;
	for my $name (keys(%USE)) {
		my $dbh = $DBH{$name};
		next unless ($CONF{$name}->{RELEASE});
		eval {
			$dbh->disconnect();
			delete($DBH{$name});
		};
		push(@err, $name) if ($@);
	}
	if (scalar(@err)) {
		die "error: ". join(',', @err);
	}
	%USE = ();
}

#-----------------------------------------------------------
# ³ DB ϥɥ rollback

sub rollback {
	my @err;
	for my $name (keys(%USE)) {
		my $dbh = $DBH{$name};
		next if (!$dbh || $dbh->{AutoCommit});
		eval {
			$dbh->rollback();
		};
		push(@err, $name) if ($@);
	}
	if (scalar(@err)) {
		MException::error("rollback err: ". join(',', @err),
			{ CODE => 4005, DBIERR => $DBI::err, MSG => $DBI::errstr });
	}
}

#-----------------------------------------------------------
# ³ DB ϥɥ commit

sub commit {
	
	# commit о
	
	my @tgtdb;
	for my $name (sort keys %USE) {
		my $dbh = $DBH{$name};
		next if (!$dbh || $dbh->{AutoCommit});
		push(@tgtdb, $name);
	}
	
	# commit  ping
	
	for my $name (@tgtdb) {
		if (!$DBH{$name}->ping) {
			MException::error("commit error: $name",
				{ CODE => 4003, DBIERR => $DBI::err, MSG => $DBI::errstr });
		}
	}
	
	# commit
	
	my %done;
	for my $name (@tgtdb) {
		eval {
			$DBH{$name}->commit();
		};
		if ($@) {
			if (scalar(%done)) {
				my (@list1, @list2);
				for (@tgtdb) {
					if ($done{$_}) {
						push(@list1, $_);
					} else {
						push(@list2, $_);
					}
				}
				MException::error(
					"partial commit error: ".
					join(',', @list1). '/'. join(',', @list2),
					{ CODE => 4004, DBIERR => $DBI::err,
						MSG => $DBI::errstr });
			} else {
				MException::error(
					"commit error: $name",
					{ CODE => 4003, DBIERR => $DBI::err,
						MSG => $DBI::errstr });
			}
		} else {
			$done{$name} = 1;
		}
	}
}

#-----------------------------------------------------------
# ̾Υ󥹤

sub getSequence {
	my $dbh = getHandle($_::DB_SEQ);
	my $sth = $dbh->prepare_cached(<<"SQL");
	update seq_$_[0] set id=LAST_INSERT_ID(id+1)
SQL
	$sth->execute();
	return($dbh->{'mysql_insertid'});
}

1;
