/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.packet;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jp.sourceforge.mmosf.server.packet.Packet;

public class LoginPacket
extends Packet {
    public static final String HOSTADDRESS = "hostadress";
    public static final String PORT = "loginPort";
    public static final String USERID = "userId";
    public static final String PASSWORD = "password";
    public static final String SUCCESS = "success";
    public static final String CONNECTID = "connectid";

    public static byte[] getDigestBytes(String str) throws NoSuchAlgorithmException {
        return LoginPacket.getDigestBytes(str.getBytes());
    }

    public static byte[] toByte(String str) {
        ByteBuffer buff = ByteBuffer.allocate(str.length() / 2);
        int i = 0;
        while (i < str.length()) {
            String hex = str.substring(i, i + 2);
            byte b = Integer.decode("#" + hex).byteValue();
            buff.put(b);
            i += 2;
        }
        return buff.array();
    }

    public static byte[] getDigestBytes(byte[] data) throws NoSuchAlgorithmException {
        byte[] digest = null;
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(data);
        digest = md.digest();
        return digest;
    }

    public static String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            String s = Integer.toHexString(data[i]);
            if (s.length() == 1) {
                sb.append("0");
            }
            if (s.length() > 2) {
                s = s.substring(s.length() - 2);
            }
            sb.append(s);
            ++i;
        }
        String string = sb.toString();
        return string;
    }

    public static String digest(String str) throws NoSuchAlgorithmException {
        byte[] digest = LoginPacket.getDigestBytes(str);
        String string = LoginPacket.toHexString(digest);
        return string;
    }
}

