/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmosf.server.loginserver;

import java.io.IOException;
import jp.sourceforge.mmosf.server.ListenerManager;
import jp.sourceforge.mmosf.server.ListeningServer;
import jp.sourceforge.mmosf.server.SocketManager;
import jp.sourceforge.mmosf.server.db.AccountManager;
import jp.sourceforge.mmosf.server.loginserver.LoginConnection;
import jp.sourceforge.mmosf.server.loginserver.LoginThread;
import jp.sourceforge.mmosf.server.loginserver.SingleProcessThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginServer
implements Runnable {
    private static final Log log = LogFactory.getLog(LoginServer.class);
    protected ListenerManager listener;
    protected ListeningServer listServer = null;
    protected AccountManager accountManager = null;

    public LoginServer(int port) throws IOException {
        this.listener = new ListenerManager(port);
    }

    public void setListeningServer(ListeningServer server) {
        this.listServer = server;
    }

    public ListeningServer getListeningServer() {
        return this.listServer;
    }

    public AccountManager getAccountManager() {
        return this.accountManager;
    }

    public void setAccountManager(AccountManager accountManager) {
        this.accountManager = accountManager;
    }

    public void run() {
        this.processBlocking2();
    }

    public void processBlocking() {
        while (true) {
            SocketManager sock = null;
            try {
                sock = this.listener.accept();
            }
            catch (IOException e) {
                log.error((Object)"error in listening.", (Throwable)e);
                break;
            }
            try {
                LoginConnection conn = new LoginConnection(sock);
                Thread th = new Thread(new LoginThread(this, conn));
                th.start();
            }
            catch (Exception e) {
                log.error((Object)"error in receive.", (Throwable)e);
            }
        }
    }

    public void processBlocking2() {
        SingleProcessThread thread = new SingleProcessThread(600);
        Thread th = new Thread(thread);
        th.start();
        while (true) {
            SocketManager sock = null;
            try {
                sock = this.listener.accept();
                LoginConnection conn = new LoginConnection(sock);
                thread.addProcess(new LoginThread(this, conn));
            }
            catch (Exception e) {
                log.error((Object)"error in listening.", (Throwable)e);
                return;
            }
        }
    }
}

