#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'

class ItemAClock < Item
    NAME = 'Analog Clock'

    include Math

    @@color_hour = Color.new(0.9, 0.9, 0.0, 0.6)
    @@color_min = Color.new(1.0, 1.0, 0.0, 0.8)
    @@color_sec = Color.new(0.8, 0.8, 0.0, 0.7)

    @@color_bg = Color.new(0.5, 0.5, 0.5, 0.8)
    @@color_arc = Color.new(0.7, 0.7, 0.7, 1.0)
    @@color_dot = Color.new(0.7, 0.7, 0.0, 1.0)

    def initialize(mmon)
        super(mmon)

        @item_name = 'Analog Clock'
        @interval = 5.0
        @use_bg = true

        @now = Time.now

        @width = 72
        @height = 72
    end

    private

    def render_mask(cc, w, h)
        render_bg(cc, w, h)
    end

    def render_bg(cc, w, h)
#        puts "aclock render_bg w:#{w} h:#{h}"

        x0 = w / 2.0
        y0 = h / 2.0
        r0 = x0

        cc.arc(x0, y0, r0, 0.0, 2 * PI)
        cc.set_source_rgba(@@color_bg)
        cc.fill

        cc.arc(x0, y0, 0.97 * r0, 0.0, 2.0 * PI)
        cc.set_line_width(0.03 * w)
        cc.set_line_cap(Cairo::LINE_CAP_ROUND)
        cc.set_source_rgba(@@color_arc)
        cc.stroke

        r = 0.86 * x0

        12.times do |i|
            radian = 2.0 * PI * i / 12
            x = r * sin(radian)
            y = r * cos(radian)

            cc.arc(x0 + x, y0 - y, 0.02 * w, 0.0, 2.0 * PI)
            cc.set_source_rgba(@@color_dot)
            cc.fill
        end
    end

    def render(cc, w, h)
#        puts "aclock render w:#{w} h:#{h}"

        hour = @now.hour
        min = @now.min
        sec = @now.sec

#        puts "aclock render h:#{hour} m:#{min} s:#{sec}"

        x0 = w / 2.0
        y0 = h / 2.0
        r = w / 2.0

        cc.set_line_cap(Cairo::LINE_CAP_ROUND)

        # hour
        rad = 2.0 * PI * (hour * 3600.0 + min * 60.0 + sec) / (12.0 * 3600.0);
        x = 0.60 * r * sin(rad);
        y = 0.60 * r * cos(rad);
        cc.set_line_width(5)
        cc.set_source_rgba(@@color_hour)
        cc.move_to(x0, y0)
        cc.line_to(x0 + x, y0 - y)
        cc.stroke

        # min
        rad = 2.0 * PI * (min * 60.0 + sec) / 3600.0;
        x = 0.85 * r * sin(rad);
        y = 0.85 * r * cos(rad);
        cc.set_line_width(4);
        cc.set_source_rgba(@@color_min)
        cc.move_to(x0, y0)
        cc.line_to(x0 + x, y0 - y)
        cc.stroke

=begin        
        # sec
        rad = 2.0 * PI * sec / 60.0;
        x = 0.85 * r * sin(rad);
        y = 0.85 * r * cos(rad);
        cc.set_line_width(2);
        cc.set_source_rgba(@@color_sec)
        cc.move_to(x0, y0)
        cc.line_to(x0 + x, y0 - y)
        cc.stroke
=end
    end

    def prepare
        old = @now
        @now = Time.now

        return true
    end
end

if __FILE__ == $0
    require 'mmon/appmmon'

    app = AppMmon.new
    item = ItemAClock.new(app)
    app.add_item(item)

    Gtk::main()
end
