# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'
require 'singleton'

class RootPixmap
    include Singleton

    def initialize()
        @enable = false
        @surface = nil

=begin
    root_window = Gdk::Window.default_root_window
	events = root_window.events
	events |= Gdk::Event::PROPERTY_CHANGE_MASK
	root_window.events = events
	root_window.add_filer
=end
    end

    def enable=(bool)
        @enable = bool 

        if @enable
            @surface = create_surface()
        else
            @surface = nil
        end
    end

    def enable?
        @enable
    end

    def render(cc, x_offset, y_offset)
        return if @enable == false
        return if @surface.nil?

        cc.set_source(@surface, -x_offset, -y_offset)
        cc.paint
    end

    private

    def create_surface
        root_window = Gdk::Window.default_root_window
        atom = Gdk::Atom.intern('_XROOTPMAP_ID', FALSE)

        ptype, pdata, psize = Gdk::Property.get(root_window, atom, Gdk::Selection::TARGET_PIXMAP, false)
        if (ptype == Gdk::Selection::TARGET_PIXMAP) && (pdata[0] != nil)
			pixmap = Gdk::Pixmap.foreign_new(pdata[0])
            w, h = pixmap.size

            pixbuf = Gdk::Pixbuf.from_drawable(root_window.colormap, pixmap, 0, 0, w, h, nil, 0, 0)
#            pixbuf.save('aaa.png', 'png')

=begin
			rcolormap = root_window.colormap
            if pixmap.colormap.nil?
				pixmap.colormap = rcolormap
            end

            cc_pixmap = pixmap.create_cairo_context
=end

            surface = Cairo::ImageSurface.new(Cairo::FORMAT_ARGB32, w, h)
            cc = Cairo::Context.new(surface)
#            cc.set_source(cc_pixmap.target, 0, 0)
            cc.set_source_pixbuf(pixbuf, 0, 0)
            cc.paint

            return surface
        else
            return nil
        end
    end
end

if __FILE__ == $0
    bg = RootPixmap.instance
end
