# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

require 'mmon/color'

module Util
include Math

COLOR_BG = Color.new(0.5, 0.5, 0.5, 0.8)
COLOR_FG = Color.new(0.7, 0.7, 0.7, 1.0)

def self.simple_bg(cc, w, h)
    l = 2.0
    simple_box(cc, w, h, l)
    cc.set_source_rgba(COLOR_BG)
    cc.fill
end

def self.simple_fg(cc, w, h)
    l = 2.0
    simple_box(cc, w, h, l)
    cc.set_line_width(l)
    cc.set_line_cap(Cairo::LINE_CAP_ROUND)
    cc.set_source_rgba(COLOR_FG)
    cc.stroke
end

def self.simple_box(cc, w, h, l)
    r = 8.0

    l2 = l / 2.0
    x0 = l2
    y0 = l2
    x1 = w - l2
    y1 = h - l2

    round_box(cc, x0, y0, x1, y1, r)
end

def self.simple_bg2(cc, w, h)
    l = 2.0
    simple_box2(cc, w, h, l)
    cc.set_source_rgba(COLOR_BG)
    cc.fill
end

def self.simple_fg2(cc, w, h)
    l = 2.0
    simple_box2(cc, w, h, l)
    cc.set_line_width(l)
    cc.set_line_cap(Cairo::LINE_CAP_ROUND)
    cc.set_source_rgba(COLOR_FG)
    cc.stroke
end

def self.simple_box2(cc, w, h, l)
    r = 8.0

    l2 = l / 2.0

    x0 = l2
    y0 = l2
    x1 = w - l2
    y1 = h / 2.0
    round_box(cc, x0, y0, x1, y1, r)

    x0 = l2
    y0 = h / 2.0
    x1 = w - l2
    y1 = h - l2
    round_box(cc, x0, y0, x1, y1, r)
end

def self.round_box(cc, x0, y0, x1, y1, r)
    a = r * 0.2

    cc.move_to(x0 + r, y0)
    cc.line_to(x1 - r, y0)
    cc.curve_to(x1 - a, y0, x1, y0 + a, x1, y0 + r)
    cc.line_to(x1, y1 - r)
    cc.curve_to(x1, y1 - a, x1 - a, y1, x1 - r, y1)
    cc.line_to(x0 + r, y1)
    cc.curve_to(x0 + a, y1, x0, y1 - a, x0, y1 - r)
    cc.line_to(x0, y0 + r)
    cc.curve_to(x0, y0 + a, x0 + a, y0, x0 + r, y0)

    cc.close_path
end

def self.str_to_bool(str)
    if str == 'true'
        return true
    else
        return false
    end
end

def self.bool_to_str(bool)
    if bool
        return 'true'
    else
        return 'false'
    end
end

end
