#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'
require 'mmon/util'
require 'mmon/memory'

class ItemMem < Item
    NAME = 'Memory'

    @@color_used = Color.new(1.0, 0.0, 0.0, 0.9)
    @@color_buffers = Color.new(0.0, 1.0, 0.0, 0.9)
    @@color_cached = Color.new(0.0, 0.0, 1.0, 0.9)
    @@color_paged = Color.new(1.0, 0.0, 1.0, 0.9)

    def initialize(parent = nil)
        super(parent)

        @interval = 1.0
        @use_bg = true
        @use_fg = true
        self.set_item_size(72, 32)

        @mem = Memory.new
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg2(cc, w, h)
        Util.simple_fg2(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg2(cc, w, h)
    end

    def render_fg(cc, w, h)
        Util.simple_fg2(cc, w, h)
    end

    def render(cc, w, h)
        @mem.read

        lw = 2.0
        rw = w - 2 * lw
        h1 = h / 2.0 - 1.5 * lw

        cc.antialias = Cairo::ANTIALIAS_NONE

        y0 = lw
        y1 = h / 2.0 + lw / 2.0

        m_total = @mem.mem_total
        s_total = @mem.swap_total

        x0 = lw 
        w0 = @mem.mem_used.to_f / m_total * rw
        cc.set_source_rgba(@@color_used)
        cc.rectangle(x0, y0, w0, h1)
        cc.fill

        x1 = x0 + w0
        w1 = @mem.mem_buffers.to_f / m_total * rw
        cc.set_source_rgba(@@color_buffers)
        cc.rectangle(x1, y0, w1, h1)
        cc.fill

        x2 = x1 + w1
        w2 = @mem.mem_cached.to_f / m_total * rw
        cc.set_source_rgba(@@color_cached)
        cc.rectangle(x2, y0, w2, h1)
        cc.fill

        # puts "#{x0} #{x1} #{x2} #{x3}"

        s0 = @mem.swap_paged.to_f / s_total * rw
        cc.set_source_rgba(@@color_paged)
        cc.rectangle(x0, y1, s0, h1)
        cc.fill
    end

    def prepare
        @mem.read

        return true
    end
end

if __FILE__ == $0
    item = ItemMem.new
    item.show

    Gtk::main()
end
