#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'
require 'mmon/image'

class ItemTClock < Item
    include Math

    NAME = 'Test Clock'

    @@color_hour = Color.new(0.9, 0.9, 0.0, 0.6)
    @@color_min = Color.new(1.0, 1.0, 0.0, 0.8)

    def initialize(parent = nil)
        super(parent)

        @item_name = 'Analog Clock'
        @interval = 5.0
        @use_bg = true

        @image = Image.new('firefox.svg', 128, 128)
        @image2 = Image.new('web-browser.svg', 128, 128)

        self.set_item_size(128, 128)

        @now = Time.now
    end

    private

    def render_mask(cc, w, h)
        @image.render(cc)
#         cc.paint
    end

    def render_bg(cc, w, h)
        @image.render(cc)
    end

    def render(cc, w, h)
        hour = @now.hour
        min = @now.min
        sec = @now.sec
        rad_h = 2.0 * PI * (hour * 3600.0 + min * 60.0 + sec) / (12.0 * 3600.0);
        rad_m = 2.0 * PI * (min * 60.0 + sec) / 3600.0;

        cc.save
        cc.translate(w / 2.0, h / 2.0)
        cc.rotate(rad_m + 2.0 * PI * 270.0 / 360.0)
        cc.translate(0.0, -h / 2.0 / 10.0)
        cc.scale(0.5, 0.1)
        @image2.render(cc)
        cc.restore

        cc.save
        cc.translate(w / 2.0, h / 2.0)
        cc.rotate(rad_h + 2.0 * PI * 270.0 / 360.0)
        cc.translate(0.0, -h / 2.0 / 10.0)
        cc.scale(0.3, 0.1)
        @image2.render(cc)
        cc.restore
=begin

        cc.operator = Cairo::OPERATOR_SOURCE

        cc.scale(w, h)
        cc.set_line_cap(Cairo::LINE_CAP_ROUND)
        cc.set_source_rgba(@@color_hour)

        # hour
        x = 0.30 * sin(rad_h)
        y = 0.30 * cos(rad_h)
        cc.set_line_width(0.06)
        cc.move_to(0.5, 0.5)
        cc.line_to(0.5 + x, 0.5 - y)
        cc.stroke

        # min
        x = 0.43 * sin(rad_m)
        y = 0.43 * cos(rad_m)
        cc.set_line_width(0.05);
        cc.move_to(0.5, 0.5)
        cc.line_to(0.5 + x, 0.5 - y)
        cc.stroke
=end
    end

    def prepare
        old = @now
        @now = Time.now

        return true
    end
end

if __FILE__ == $0
    item = ItemTClock.new
    p ItemTClock.const_get(:NAME)
    item.show

    Gtk::main()
end
