#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'
require 'mmon/util'
require 'mmon/trend_buffer'
require 'mmon/cpu'

class ItemCpu < Item
    NAME = 'CPU'

    @@color_user = Color.new(0.0, 1.0, 0.0, 0.9)
    @@color_nice = Color.new(0.0, 1.0, 1.0, 0.9)
    @@color_system = Color.new(1.0, 0.0, 1.0, 0.9)

    def initialize(parent = nil)
        super(parent)

        @interval = 0.5
        @use_bg = true
        @use_fg = true
        w = 72
        h = 32
        self.set_item_size(w, h)

        @trend = TrendBuffer.new(w, h)

        @cpu = Cpu.new
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg(cc, w, h)
    end

    def render_fg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render(cc, w, h)
        tcc = @trend.cairo_context

        cc.set_source(tcc.target, 0, 0)
        cc.paint
    end

    def prepare
        w, h = self.item_size()

        @cpu.read

        @trend.shift
        tcc = @trend.cairo_context

        l = 2.0
        rh = h - 2.0 * l

        x = w - l
        y0 = h - l 

        # ２回に１回程度の割合で mmon 自身の２％の CPU 負荷（0.6 ピクセル相当）を
        # １ピクセルで表示してうっとうしい。
        # インチキくさいが１ピクセル未満の負荷は切捨てて表示しないようにする。
        y1 = y0 - (@cpu.user * rh).to_i
        y2 = y1 - (@cpu.nice * rh).to_i
        y3 = y2 - (@cpu.system * rh).to_i

#        puts "y0:#{y0} y1:#{y1} y2:#{y2} y3:#{y3}"

        tcc.set_line_width(1)

        # user
        tcc.set_source_rgba(@@color_user)
        tcc.move_to(x, y0)
        tcc.line_to(x, y1)
        tcc.stroke

        # nice
        tcc.set_source_rgba(@@color_nice)
        tcc.move_to(x, y1)
        tcc.line_to(x, y2)
        tcc.stroke

        # system
        tcc.set_source_rgba(@@color_system)
        tcc.move_to(x, y2)
        tcc.line_to(x, y3)
        tcc.stroke

        return true
    end
end

if __FILE__ == $0
    item = ItemCpu.new
    item.show

    Gtk::main()
end
