#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'mmon/item'
require 'mmon/util'
require 'mmon/label'

class ItemCal < Item
    NAME = 'Calendar'

    @@color_text = Color.new(1.0, 1.0, 0.0, 1.0)

    def initialize(parent = nil)
        super(parent)

        @interval = 2.0
        @use_bg = true
        self.set_item_size(72, 32)

        @wtext = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat']
        #@wtext = ['日', '月', '火', '水', '木', '金', '土']

        @now = Time.now

        @label_ym = Label.new(nil, 11, false, true, @@color_text, 0.5 * @width, 0.28 * @height)
        @label_ym.text = @now.strftime('%Y/%m')

        @label_wd = Label.new(nil, 11, false, true, @@color_text, 0.3 * @width, 0.72 * @height)
        @label_wd.text = @wtext[@now.wday]

        @label_d = Label.new(nil, 14, false, true, @@color_text, 0.72 * @width, 0.72 * @height)
        @label_d.text = @now.strftime('%d')
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render(cc, w, h)
        cc.operator = Cairo::OPERATOR_SOURCE

        @label_ym.render(cc)
        @label_wd.render(cc)
        @label_d.render(cc)
    end

    def prepare
        old = @now
        @now = Time.now

        if old.day != @now.day
            @label_ym.text = @now.strftime('%Y/%m')
            @label_wd.text = @wtext[@now.wday]
            @label_d.text = @now.strftime('%d')
            return true
        else 
            return false
        end
    end
end

if __FILE__ == $0
    item = ItemCal.new
    item.show

    Gtk::main()
end
