# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'
require 'rsvg2'

class Image
    def initialize(file_path = '', w = 0, h = 0)
        @x = 0
        @y = 0
        @w = w
        @h = h

        @file_path = file_path

        @surface = create_surface()
    end

    def position(x, y)
        # puts "Image position #{x} #{y}"
        @x = x
        @y = y
    end

    def size(w, h)
        @w = w
        @h = h
        @surface = create_surface()
    end

    def render(cc)
        cc.save
        cc.translate(@x, @y)

        unless @surface.nil?
            cc.set_source(@surface, 0, 0)
            cc.paint
        end

        cc.restore
    end
    private

    def create_surface()
        surface = Cairo::ImageSurface.new(Cairo::FORMAT_ARGB32, @w, @h)

        cc = Cairo::Context.new(surface)
#        cc.operator = Cairo::OPERATOR_CLEAR
#        cc.paint
#        cc.operator = Cairo::OPERATOR_SOURCE

        if @file_path.empty? || FileTest.exist?(@file_path) == false
            cc.set_source_rgba(1.0, 1.0, 1.0, 1.0)
            cc.paint
        else
            case File.extname(@file_path) 
            when '.png', '.jpg', '.xpm'
                buf = Gdk::Pixbuf.new(@file_path)
                if @w == 0 || @h == 0
                    pixbuf = buf
                else
                    pixbuf = buf.scale(@w, @h)
                end
                cc.set_source_pixbuf(pixbuf, 0, 0)
                cc.paint

            when '.svg' 
                handle = RSVG::Handle.new_from_file(@file_path)
                unless @w == 0 || @h == 0
                    scale_x =  @w.to_f / handle.width
                    scale_y =  @h.to_f / handle.height
                    cc.scale(scale_x, scale_y)
                end
                cc.render_rsvg_handle(handle)

                #puts "w:#{handle.width} h:#{handle.height}"
            else
                cc.set_source_rgba(1.0, 1.0, 1.0, 1.0)
                cc.paint
            end
        end
        return surface
    end
end

if __FILE__ == $0
    image = Image.new(ARGV[0])

end
