# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

=begin

/proc/stat のサンプル

cpu  12540 0 1952 215408 3954 92 985 0
cpu0 12540 0 1952 215408 3954 92 985 0
intr 762818 587299 5846 0 0 0 0 3 2 0 0 11987 145731 3 0 11909 38
ctxt 993520
btime 1166228374
processes 2795
procs_running 2
procs_blocked 0

=end

class Cpu
    attr_reader :user, :nice, :system, :idle

    def initialize
        @raw_user = 0.0
        @raw_nice = 0.0
        @raw_system = 0.0
        @raw_idle = 0.0

        @user = 0.0
        @nice = 0.0
        @system = 0.0
        @idle = 1.0

        read()
    end

    REG = /^cpu\s+(\d+) (\d+) (\d+) (\d+)/

    def read
#        puts 'cpu read'

        user_old = @raw_user
        nice_old = @raw_nice
        system_old = @raw_system
        idle_old = @raw_idle

        begin
            f = File.open('/proc/stat')
            if f.readline =~ REG
                @raw_user = $1.to_f
                @raw_nice = $2.to_f
                @raw_system = $3.to_f
                @raw_idle = $4.to_f
                #puts "##raw## user:#{@raw_user}  nice:#{@raw_nice}  system:#{@raw_system}   idle:#{@raw_idle}"
            end
        rescue
            p $!
        ensure
            f.close
        end

        duser = @raw_user - user_old
        dnice = @raw_nice - nice_old
        dsystem = @raw_system - system_old
        didle = @raw_idle - idle_old
        dtotal = duser + dnice + dsystem + didle

        dtotal = 1.0 if dtotal.zero?

        @user = duser / dtotal
        @nice = dnice / dtotal
        @system = dsystem / dtotal
        @idle = didle / dtotal
    end

    def print
        puts "user:#{@user}  nice:#{@nice}  system:#{@system}  idle:#{@idle}"
    end
end

if __FILE__ == $0
    cpu = Cpu.new
    sleep(1)
    cpu.read
    cpu.print
end
