# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'cairo'

class TrendBuffer
    def initialize(width = 1, height = 1)
        surface0 = Cairo::ImageSurface.new(Cairo::FORMAT_ARGB32, width, height)
        surface1 = Cairo::ImageSurface.new(Cairo::FORMAT_ARGB32, width, height)

        @current_surface = 0

        @cc0 = Cairo::Context.new(surface0)
        @cc1 = Cairo::Context.new(surface1)

        @cc0.operator = Cairo::OPERATOR_CLEAR
        @cc0.paint
        @cc1.operator = Cairo::OPERATOR_CLEAR
        @cc1.paint
    end

    def cairo_context
        if @current_surface == 0
            return @cc0
        else
            return @cc1
        end
    end

    def shift
        if @current_surface == 0
            target = @cc0.target
            cc = @cc1
            @current_surface = 1
        else
            target = @cc1.target
            cc = @cc0
            @current_surface = 0
        end

        cc.antialias = Cairo::ANTIALIAS_NONE
        cc.operator = Cairo::OPERATOR_SOURCE
        cc.set_source(target, -1, 0)
        cc.paint
    end
end

