#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

require 'item'
require 'util'

class ItemTemp < Item
    def initialize(parent = nil)
        super(parent)

        @interval = 1.0
        @use_bg = true
        self.set_item_size(72, 32)

        @temp1_input = ''
        @temp2_input = ''

        # 総当たりでファイル名が temp?_input なファイルを探す  
        # こんな方法でいいのかは不明だがとりあえず動く
        IO.popen("find /sys -name temp?_input") do |io|
            io.each_line do |l|
                l.chomp!
                case l
                when /temp1_input$/ then @temp1_input = l
                when /temp2_input$/ then @temp2_input = l
                end
            end
        end

        @temp1 = 0.0
        @temp2 = 0.0
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render(cc, w, h)
#        puts 'temp render'
        
        if @temp1_input == '' && @temp2_input == ''
            t1 = '??'
            t2 = '??'
        else
            t1 = sprintf("%4.1f", @temp1)
            t2 = sprintf("%4.1f", @temp2)
        end

        cc.select_font_face("Bitstream Vera Sans", Cairo::FONT_SLANT_NORMAL, Cairo::FONT_WEIGHT_BOLD);
        cc.set_source_rgb(1.0, 1.0, 0.0);
        cc.set_font_size(14)

        extents = cc.text_extents(t1)
        x = (0.5 * w) - (extents.width / 2)
        y = (0.3 * h)  + (extents.height / 2)
        cc.move_to(x, y)
        cc.show_text(t1)

        extents = cc.text_extents(t2)
        x = (0.5 * w) - (extents.width / 2)
        y = (0.7 * h) + (extents.height / 2)
        cc.move_to(x, y)
        cc.show_text(t2)
    end

    def prepare
        #puts 'prepare temp'
        
        if @temp1_input == '' && @temp2_input == ''
            return false
        end

        oldtemp1 = @temp1
        oldtemp2 = @temp2
        begin
            # 素直に読むと f.read した時に止まる
            # ruby-gnome2 のメーリングリストに同じ問題についてのスレッドがある
            # ruby-gnome2 が原因ではないらしい
            if File.exist?(@temp1_input)
                IO.popen("cat #{@temp1_input}") { |io| @temp1 = io.read.to_f / 1000.0 }
            else
                @temp1 = 0.0
            end

            if File.exist?(@temp2_input)
                IO.popen("cat #{@temp2_input}") { |io| @temp2 = io.read.to_f / 1000.0 }
            else
                @temp2 = 0.0
            end

            #puts @temp1.to_s + ' ' + @temp2.to_s
        rescue
            p $!
        ensure 
        end

        if oldtemp1 == @temp1 && oldtemp2 == @temp2 
            return false
        else
            return true
        end
    end

    def read_element_localvalue(e)
        e_temp1 = e.elements['temp1_input']
        @temp1_input = e_temp1.text.to_i unless e_temp1.nil?
        e_temp2 = e.elements['temp2_input']
        @temp2_input = e_temp2.text.to_i unless e_temp2.nil?
    end

    def write_element_local(e)
        e_1 = REXML::Element.new('temp1_input')
        e_1.text = @temp1_input
        e_2 = REXML::Element.new('temp2_input')
        e_2.text = @temp2_input

        e.add_element(e_1)
        e.add_element(e_2)
    end

    def setting_widget(x, y)
        label_title = Gtk::Label.new('file location (/sys/.../temp[12]_input)')

        fcb1 = Gtk::FileChooserButton.new('Select "temp1_input"', Gtk::FileChooser::Action::OPEN)
        fcb1.filename = @temp1_input
        fcb2 = Gtk::FileChooserButton.new('Select "temp2_input"', Gtk::FileChooser::Action::OPEN)
        fcb2.filename = @temp2_input

        fcb1.signal_connect('selection-changed') do |w|
            @temp1_input = w.filename
        end

        fcb2.signal_connect('selection-changed') do |w|
            @temp2_input = w.filename
        end

        vbox = Gtk::VBox.new
        vbox.pack_start(fcb1, false, false, 10)
        vbox.pack_start(fcb2, false, false, 10)

        return vbox
    end
end

if __FILE__ == $0
    item = ItemTemp.new
    item.show

    Gtk::main()
end
