#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

require 'item'
require 'util'
require 'trend_buffer'

=begin

/proc/net/dev のサンプル

Inter-|   Receive                                                |  Transmit
 face |bytes    packets errs drop fifo frame compressed multicast|bytes    packets errs drop fifo colls carrier compressed
    lo:     756      14    0    0    0     0          0         0      756      14    0    0    0     0       0          0
  eth0: 3601487    3713    0    0    0     0          0         0   293704    2915    0    0    0     4       0          0

=end

class ItemNet < Item
    def initialize(parent = nil)
        super(parent)

        @interval = 0.5
        @use_bg = true
        @use_fg = true
        w = 72
        h = 32
        self.set_item_size(w, h)

        @trend = TrendBuffer.new(w, h)

        @in_max = 512000
        @out_max = 64000

        @stat = Stat.new
    end

    def render_mask(cc, w, h)
        Util.simple_bg2(cc, w, h)
        Util.simple_fg2(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg2(cc, w, h)
    end

    def render_fg(cc, w, h)
        Util.simple_fg2(cc, w, h)
    end

    def render(cc, w, h)
        tcc = @trend.cairo_context

        cc.set_source(tcc.target, 0, 0)
        cc.paint
    end

    private

    def prepare
        # puts 'prepare net'

        w, h = self.item_size()

        @stat.read

        @trend.shift
        tcc = @trend.cairo_context

        s = @stat

        lw = 2.0
        w2 = lw / 2.0

        rh = h / 2.0 - lw - w2

        x = w - lw
        y0 = h / 2.0 - w2
        h0 = -rh * s.din.to_f / (s.dnow * @in_max)
        y1 = h - lw
        h1 = -rh * s.dout.to_f / (s.dnow * @out_max)

#puts "y0:#{y0} y1:#{y1} y2:#{y2} y3:#{y3}"

        tcc.set_line_width(1)

        tcc.set_source_rgb(0.0, 1.0, 1.0)
        tcc.move_to(x, y0)
        tcc.rel_line_to(0, h0)
        tcc.stroke

        tcc.set_source_rgb(0.0, 0.8, 0.8)
        tcc.move_to(x, y1)
        tcc.rel_line_to(0, h1)
        tcc.stroke

        return true
    end

    def read_element_localvalue(e)
        e_in_max = e.elements['in_max']
        @in_max = e_in_max.text.to_i unless e_in_max.nil?
        e_out_max = e.elements['out_max']
        @out_max = e_out_max.text.to_i unless e_out_max.nil?
    end

    def write_element_local(e)
        e_in = REXML::Element.new('in_max')
        e_in.text = @in_max.to_s
        e_out = REXML::Element.new('out_max')
        e_out.text = @out_max.to_s

        e.add_element(e_in)
        e.add_element(e_out)
    end

    def setting_widget(x, y)
        label_title = Gtk::Label.new('bandwidth (KByte/s)')

        label_in = Gtk::Label.new('in')
        label_out = Gtk::Label.new('out')

        spin_in = Gtk::SpinButton.new(1.0, 12500.0, 1.0) 
        spin_out = Gtk::SpinButton.new(1.0, 12500.0, 1.0) 

        spin_in.signal_connect('value-changed') do |w|
            @in_max = w.value.to_i * 1000
        end
        spin_out.signal_connect('value-changed') do |w|
            @out_max = w.value.to_i * 1000
        end

        spin_in.set_value(@in_max / 1000)
        spin_out.set_value(@out_max / 1000)

        table = Gtk::Table.new(2, 2)
        table.attach(label_in, 0, 1, 0, 1)
        table.attach(label_out, 0, 1, 1, 2)

        table.attach(spin_in, 1, 2, 0, 1)
        table.attach(spin_out, 1, 2, 1, 2)


        vbox = Gtk::VBox.new
        vbox.pack_start(label_title, false, false, 10)
        vbox.pack_start(table, false, false, 10)

        return vbox
    end

    class Stat
        attr_reader :din, :dout, :dnow

        def initialize
            @in = 0         # byte
            @out = 0        # byte
            @now = Time.now

            @din = 0
            @dout = 0
            @dnow = 0

            read()
        end

        REG = /eth0:\s*(\d+)\s+\d+\s+\d+\s+\d+\s+\d+\s+\d+\s+\d+\s+\d+\s+(\d+)/

        def read
#           puts 'net stat_read'

            in_old = @in
            out_old = @out
            now_old = @now

            begin
                f = File.open('/proc/net/dev')
                f.each_line do |l|
                    next unless l =~ /^  eth0/

                    if REG =~ l
                        @in = $1.to_i
                        @out = $2.to_i
                        @now = Time.now
#                    puts "row in:#{@in}  out:#{@out}"
                    end
                end
            rescue
                p $!
            ensure
                f.close
            end

            @din = @in - in_old
            @dout = @out - out_old
            @dnow = @now - now_old

#            puts "byte in:#{@din}  out:#{@dout} time:#{@dnow}"
        end
    end

end

if __FILE__ == $0
    item = ItemNet.new
    item.show

    Gtk::main()
end
