#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

require 'item'
require 'util'

=begin

/proc/meminfo のサンプル

MemTotal:       776344 kB
MemFree:        370248 kB
Buffers:         31240 kB
Cached:         175584 kB
SwapCached:          0 kB
Active:         266012 kB
Inactive:       116104 kB
HighTotal:           0 kB
HighFree:            0 kB
LowTotal:       776344 kB
LowFree:        370248 kB
SwapTotal:      987956 kB
SwapFree:       987956 kB
Dirty:               8 kB
Writeback:           0 kB
AnonPages:      175312 kB
Mapped:          51732 kB
Slab:            13540 kB
PageTables:       1304 kB
NFS_Unstable:        0 kB
Bounce:              0 kB
CommitLimit:   1376128 kB
Committed_AS:   341848 kB
VmallocTotal:   253912 kB
VmallocUsed:     23108 kB
VmallocChunk:   226772 kB

=end

class ItemMem < Item
    include Math

    def initialize(parent = nil)
        super(parent)

        @interval = 1.0
        @use_bg = true
        @use_fg = true
        self.set_item_size(72, 32)

        @mem_total = 0
        @mem_free = 0
        @mem_buffers = 0
        @mem_cached = 0

        @swap_total = 0
        @swap_free = 0
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg2(cc, w, h)
        Util.simple_fg2(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg2(cc, w, h)
    end

    def render_fg(cc, w, h)
        Util.simple_fg2(cc, w, h)
    end

    def render(cc, w, h)
#puts 'render mem'
        return if @mem_total.zero?

        used = @mem_total - @mem_free - @mem_buffers - @mem_cached
        paged = @swap_total - @swap_free

        lw = 2.0
        rw = w - 2 * lw
        h = h / 2.0 - 1.5 * lw

        cc.antialias = Cairo::ANTIALIAS_NONE

        y0 = lw
        y1 = h / 2.0 + lw / 2.0

        x0 = lw 
        w0 = used.to_f / @mem_total * rw
        cc.set_source_rgba(1.0, 0.0, 0.0, 0.9)
        cc.rectangle(x0, y0, w0, h)
        cc.fill

        x1 = x0 + w0
        w1 = @mem_buffers.to_f / @mem_total * rw
        cc.set_source_rgba(0.0, 1.0, 0.0, 0.9)
        cc.rectangle(x1, y0, w1, h)
        cc.fill

        x2 = x1 + w1
        w2 = @mem_cached.to_f / @mem_total * rw
        cc.set_source_rgba(0.0, 0.0, 1.0, 0.9)
        cc.rectangle(x2, y0, w2, h)
        cc.fill

        # puts "#{x0} #{x1} #{x2} #{x3}"

        s0 = paged.to_f / @swap_total * rw
        cc.set_source_rgba(1.0, 0.0, 0.0, 0.9)
        cc.rectangle(x0, y1, s0, h)
        cc.fill
    end

    REG_TOTAL = /^MemTotal:\s+(\d+) kB/
    REG_FREE = /^MemFree:\s+(\d+) kB/
    REG_BUFFERS = /^Buffers:\s+(\d+) kB/ 
    REG_CACHED = /^Cached:\s+(\d+) kB/
    REG_STOTAL = /^SwapTotal:\s+(\d+) kB/
    REG_SFREE = /^SwapFree:\s+(\d+) kB/ 

    def prepare
        # puts 'prepare mem'

        begin
            f = File.open('/proc/meminfo')
            f.each_line do |l|
                case l
                when REG_TOTAL then @mem_total = $1.to_i
                when REG_FREE  then @mem_free = $1.to_i
                when REG_BUFFERS then @mem_buffers = $1.to_i
                when REG_CACHED  then @mem_cached = $1.to_i
                when REG_STOTAL  then @swap_total = $1.to_i
                when REG_SFREE   then @swap_free = $1.to_i
                end
            end
            
=begin
            puts "total  :#{@mem_total}"
            puts "free   :#{@mem_free}"
            puts "buffers:#{@mem_buffers}"
            puts "cached :#{@mem_cached}"
            puts "stotal :#{@swap_total}"
            puts "sfree  :#{@swap_free}"
=end
            
            state = true
        rescue
            state = false
            p $!
        ensure 
            f.close
        end

        return state
    end
end

if __FILE__ == $0
    item = ItemMem.new
    item.show

    Gtk::main()
end
