#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'

require 'item'
require 'util'
require 'trend_buffer'

=begin

/proc/stat のサンプル

cpu  12540 0 1952 215408 3954 92 985 0
cpu0 12540 0 1952 215408 3954 92 985 0
intr 762818 587299 5846 0 0 0 0 3 2 0 0 11987 145731 3 0 11909 38
ctxt 993520
btime 1166228374
processes 2795
procs_running 2
procs_blocked 0

=end

class ItemCpu < Item
    include Math

    def initialize(parent = nil)
        super(parent)

        @interval = 0.5
        @use_bg = true
        @use_fg = true
        w = 72
        h = 32
        self.set_item_size(w, h)

        @trend = TrendBuffer.new(w, h)

        @stat = Stat.new
    end

    private

    def render_mask(cc, w, h)
        Util.simple_bg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render_bg(cc, w, h)
        Util.simple_bg(cc, w, h)
    end

    def render_fg(cc, w, h)
        Util.simple_fg(cc, w, h)
    end

    def render(cc, w, h)
        tcc = @trend.cairo_context

        cc.set_source(tcc.target, 0, 0)
        cc.paint
    end

    def prepare
        w, h = self.item_size()

        @stat.read

        @trend.shift
        tcc = @trend.cairo_context

        l = 2.0
        rh = h - 2.0 * l

        x = w - l
        y0 = h - l 

        # ２回に１回程度の割合で mmon 自身の２％の CPU 負荷（0.6 ピクセル相当）を
        # １ピクセルで表示してうっとうしい。
        # インチキくさいが１ピクセル未満の負荷は切捨てて表示しないようにする。
        y1 = y0 - (@stat.ru * rh).to_i
        y2 = y1 - (@stat.rn * rh).to_i
        y3 = y2 - (@stat.rs * rh).to_i

#        puts "y0:#{y0} y1:#{y1} y2:#{y2} y3:#{y3}"
#        puts "h0:#{@stat.ru * rh} h1:#{@stat.rn * rh} h2:#{@stat.rs * rh}"

        tcc.set_line_width(1)

        # user
        tcc.set_source_rgb(0.0, 1.0, 0.0)
        tcc.move_to(x, y0)
        tcc.line_to(x, y1)
        tcc.stroke

        # nice
        tcc.set_source_rgb(0.0, 1.0, 1.0)
        tcc.move_to(x, y1)
        tcc.line_to(x, y2)
        tcc.stroke

        # system
        tcc.set_source_rgb(1.0, 0.0, 1.0)
        tcc.move_to(x, y2)
        tcc.line_to(x, y3)
        tcc.stroke

        return true
    end

    class Stat
        attr_reader :ru, :rn, :rs, :ri

        def initialize
            @user = 0.0
            @nice = 0.0
            @system = 0.0
            @idle = 0.0

            @ru = 0.0
            @rn = 0.0
            @rs = 0.0
            @ri = 1.0

            read()
        end

        REG = /^cpu\s+(\d+) (\d+) (\d+) (\d+)/

        def read
#           puts 'cpu read'

            user_old = @user
            nice_old = @nice
            system_old = @system
            idle_old = @idle

            begin
                f = File.open('/proc/stat')
                if f.readline =~ REG
                    @user = $1.to_f
                    @nice = $2.to_f
                    @system = $3.to_f
                    @idle = $4.to_f
                    #puts "user:#{@user}  nice:#{@nice}  system:#{@system}   idle:#{@idle}"
                end
            rescue
                p $!
            ensure
                f.close
            end

            duser = @user - user_old
            dnice = @nice - nice_old
            dsystem = @system - system_old
            didle = @idle - idle_old
            dtotal = duser + dnice + dsystem + didle

            dtotal = 1.0 if dtotal.zero?

            @ru = duser / dtotal
            @rn = dnice / dtotal
            @rs = dsystem / dtotal
            @ri = didle / dtotal

            #puts "user:#{@ru}  nice:#{@rn}  system:#{@rs}   idle:#{@ri}"
        end
    end
end

if __FILE__ == $0
    item = ItemCpu.new
    item.show

    Gtk::main()
end
