#!/usr/bin/ruby -Ku
#
# mmon
#
# Copyright (c) 2007 sanpo
#
# This program is free software.
# You can redistribute it and/or modify it under the terms of the GPL.

require 'gtk2'
require 'gtkglext'

require 'glitem'
require 'util'

=begin

/proc/stat のサンプル

cpu  12540 0 1952 215408 3954 92 985 0
cpu0 12540 0 1952 215408 3954 92 985 0
intr 762818 587299 5846 0 0 0 0 3 2 0 0 11987 145731 3 0 11909 38
ctxt 993520
btime 1166228374
processes 2795
procs_running 2
procs_blocked 0

=end

class GLItemCpu < GLItem
    include Math

    def initialize(parent = nil)
        super(parent)

        @interval = 0.5
        @width = 72 
        @height = 32

        @stat = Stat.new

        @n = @width
        @load = Array.new(@n, 0.0)

        self.create_bg()
        self.create_fg()
    end

    private

    def render_mask(cc)
        Util.simple_bg(cc, @width, @height)
        Util.simple_fg(cc, @width, @height)
    end

    def render_bg(cc)
        Util.simple_bg(cc, @width, @height)
    end

    def render_fg(cc)
        Util.simple_fg(cc, @width, @height)
    end

    def render(cc)
        #puts "load:#{@load[@n - 1]}"

        GL.LineWidth(1.0)
        GL.Begin(GL::TRIANGLE_STRIP)
        @n.times do |n|
            r = @load[n]
            x = n.to_f / @n * @width
            y = r * @height

#            puts "x:#{x} y:#{y}"

            GL.Color(0.0, 1.0, 0.0)
            GL.Vertex(x, 0.0)
            GL.Color(r, 1.0 - r, 0.0)
            GL.Vertex(x, y)
        end
        GL.End

        GL.LineWidth(3.0)
        GL.Color(0.0, 1.0, 0.0, 1.0)
        GL.Begin(GL::LINES)
        GL.Vertex(-5.0, -5.0)
        GL.Vertex(65.0, 65.0)
        GL.End
    end

    def prepare
        @stat.read

        sum = @stat.ru 
        sum += @stat.rn 
        sum += @stat.rs 

        @load.shift
        @load << sum

#        puts "ru:#{@stat.ru} rn:#{@stat.rn} rs:#{@stat.rs}"

        return true
    end

    class Stat
        attr_reader :ru, :rn, :rs, :ri

        def initialize
            @user = 0.0
            @nice = 0.0
            @system = 0.0
            @idle = 0.0

            @ru = 0.0
            @rn = 0.0
            @rs = 0.0
            @ri = 1.0

            read()
        end

        def get_array
            [@ru, @rn, @rs, @ri]
        end

        REG = /^cpu\s+(\d+) (\d+) (\d+) (\d+)/

        def read
#           puts 'cpu read'

            user_old = @user
            nice_old = @nice
            system_old = @system
            idle_old = @idle

            begin
                f = File.open('/proc/stat')
                if f.readline =~ REG
                    @user = $1.to_f
                    @nice = $2.to_f
                    @system = $3.to_f
                    @idle = $4.to_f
                    #puts "user:#{@user}  nice:#{@nice}  system:#{@system}   idle:#{@idle}"
                end
            rescue
                p $!
            ensure
                f.close
            end

            duser = @user - user_old
            dnice = @nice - nice_old
            dsystem = @system - system_old
            didle = @idle - idle_old
            dtotal = duser + dnice + dsystem + didle

            dtotal = 1.0 if dtotal.zero?

            @ru = duser / dtotal
            @rn = dnice / dtotal
            @rs = dsystem / dtotal
            @ri = didle / dtotal

            #puts "user:#{@ru}  nice:#{@rn}  system:#{@rs}   idle:#{@ri}"
        end
    end
end

if __FILE__ == $0
    item = GLItemCpu.new
    item.show_all

    Gtk::main()
end
