#!/usr/bin/env bash
# Initial author of this script: Martin.Vahi@softf1.com
# This script is in the public domain.
#==========================================================================
S_FP_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
S_FP_ORIG="`pwd`"
#S_TIMESTAMP="`date +%Y`_`date +%m`_`date +%d`_T_`date +%H`h_`date +%M`min_`date +%S`s"
#--------------------------------------------------------------------------
if [ "$MMMV_BASHRC_LC_DEVELOPMENT_MACHINE_PSEUDONAME" == "mmmv_dev_machine_0001" ]; then
    echo ""
    echo "Wrong testing machine! Exiting without doing anything."
    echo "GUID=='bf6c4016-92e9-40c3-a2b0-2262f04014e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1;
fi

source "$S_FP_DIR/bonnet/common.bash"
S_FP_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"

#--------------------------------------------------------------------------
#func_mmmv_exit_if_not_on_path_t2 "grep"
func_mmmv_exit_if_not_on_path_t2 "pip2"
#func_mmmv_exit_if_not_on_path_t2 "python2"

#--------------------------------------------------------------------------
S_ARGV_0="$1"
if [ "$S_ARGV_0" != "" ]; then
    if [ "$S_ARGV_0" == "i" ]; then
        $S_FP_INSTALL_PYTHON2_MODULES_BASH ft
        func_mmmv_wait_and_sync_t1
        $S_FP_INITIALIZE_SERVER_INSTANCE_BASH
        func_mmmv_wait_and_sync_t1
    else
        echo ""
        echo "This script does not support console argument $S_ARGV_0"
        echo "Aborting script."
        echo "GUID=='3ab71741-53d5-47fe-a1b0-2262f04014e7'"
        echo ""
        cd "$S_FP_ORIG"
        exit 1
    fi
fi
#--------------------------------------------------------------------------
if [ ! -e "$PYTHONUSERBASE" ]; then
    echo ""
    echo "Failed to find the Python2 pip2 modules folder"
    echo ""
    echo "    $PYTHONUSERBASE"
    echo ""
    echo "Please run the "
    echo ""
    echo "    $S_FP_INSTALL_PYTHON2_MODULES_BASH --redownload"
    echo ""
    echo "before running this script. Aborting script."
    echo "GUID=='3570e1f4-402f-488b-8fb0-2262f04014e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1;
fi
#--------------------------------------------------------------------------
if [ ! -e "$S_FP_SYMLINK_2_SELECTED_SERVER_INSTANCE" ]; then
    echo ""
    echo "The "
    echo ""
    echo "    $S_FP_SYMLINK_2_SELECTED_SERVER_INSTANCE"
    echo ""
    echo "is either broken or it does not exist. "
    echo "It might be created by running the "
    echo ""
    echo "    $S_FP_INITIALIZE_SERVER_INSTANCE_BASH"
    echo ""
    echo "Aborting script."
    echo "GUID=='fb2f0619-2857-4004-88b0-2262f04014e7'"
    echo ""
    cd "$S_FP_ORIG"
    exit 1
fi

# Symlinks to folders also pass.
func_assert_folder_exists_t1  \
   "$S_FP_SYMLINK_2_SELECTED_SERVER_INSTANCE" "1c1aa614-58df-48a1-91b0-2262f04014e7"

#--------------------------------------------------------------------------
# The zeronet.py has the following 
# optional arguments:
#   -h, --help            show this help message and exit
#   --verbose             More detailed logging (default: False)
#   --debug               Debug mode (default: False)
#   --silent              Disable logging to terminal output (default: False)
#   --debug_socket        Debug socket connections (default: False)
#   --batch               Batch mode (No interactive input for commands)
#                         (default: False)
#   --config_file path    Path of config file (default: ./zeronet.conf)
#   --data_dir path       Path of data directory (default: ./data)
#   --log_dir path        Path of logging directory (default: ./log)
#   --log_level {DEBUG,INFO,ERROR}
#                         Level of logging to file (default: DEBUG)
#   --log_rotate {hourly,daily,weekly,off}
#                         Log rotate interval (default: daily)
#   --log_rotate_backup_count LOG_ROTATE_BACKUP_COUNT
#                         Log rotate backup count (default: 5)
#   --language language   Web interface language (default: en)
#   --ui_ip ip            Web interface bind address (default: 127.0.0.1)
#   --ui_port port        Web interface bind port (default: 43110)
#   --ui_restrict [ip [ip ...]]
#                         Restrict web access (default: False)
#   --ui_host [host [host ...]]
#                         Allow access using this hosts (default: None)
#   --ui_trans_proxy      Allow access using a transparent proxy (default:
#                         False)
#   --open_browser [browser_name]
#                         Open homepage in web browser automatically (default:
#                         None)
#   --homepage address    Web interface Homepage (default:
#                         1HeLLo4uzjaLetFx6NH3PMwFP3qbRbTf3D)
#   --updatesite address  Source code update site (default:
#                         1UPDatEDxnvHDo7TXvq6AEBARfNkyfxsp)
#   --size_limit limit    Default site size limit in MB (default: 10)
#   --file_size_limit limit
#                         Maximum per file size limit in MB (default: 10)
#   --connected_limit connected_limit
#                         Max connected peer per site (default: 8)
#   --global_connected_limit global_connected_limit
#                         Max connections (default: 512)
#   --workers workers     Download workers per site (default: 5)
#   --fileserver_ip ip    FileServer bind address (default: *)
#   --fileserver_port port
#                         FileServer bind port (0: randomize) (default: 0)
#   --fileserver_port_range port
#                         FileServer randomization range (default: 10000-40000)
#   --ip_local [ip [ip ...]]
#                         My local ips (default: ['127.0.0.1'])
#   --disable_udp         Disable UDP connections (default: False)
#   --proxy ip:port       Socks proxy address (default: None)
#   --bind ip             Bind outgoing sockets to this address (default: None)
#   --ip_external ip      Set reported external ip (tested on start if None)
#                         (default: None)
#   --trackers [protocol://address [protocol://address ...]]
#                         Bootstraping torrent trackers (default:
#                         ['zero://boot3rdez4rzn36x.onion:15441', 'zero://zero.b
#                         ooth.moe#f36ca555bee6ba216b14d10f38c16f7769ff064e0e37d
#                         887603548cc2e64191d:443',
#                         'udp://tracker.coppersurfer.tk:6969',
#                         'udp://5.79.83.193:6969',
#                         'udp://104.238.198.186:8000',
#                         'http://tracker.swateam.org.uk:2710/announce',
#                         'http://open.acgnxtracker.com:80/announce',
#                         'http://retracker.mgts.by:80/announce'])
#   --trackers_file path  Load torrent trackers dynamically from a file
#                         (default: False)
#   --trackers_proxy TRACKERS_PROXY
#                         Force use proxy to connect to trackers (disable, tor,
#                         ip:port) (default: disable)
#   --use_openssl {True,False}
#                         Use OpenSSL liblary for speedup (default: True)
#   --disable_db          Disable database updating (default: False)
#   --disable_encryption  Disable connection encryption (default: False)
#   --force_encryption    Enforce encryption to all peer connections (default:
#                         False)
#   --disable_sslcompression {True,False}
#                         Disable SSL compression to save memory (default: True)
#   --keep_ssl_cert       Disable new SSL cert generation on startup (default:
#                         False)
#   --max_files_opened limit
#                         Change maximum opened files allowed by OS to this
#                         value on startup (default: 2048)
#   --stack_size thread_stack_size
#                         Change thread stack size (default: None)
#   --use_tempfiles {True,False}
#                         Use temporary files when downloading (experimental)
#                         (default: False)
#   --stream_downloads {True,False}
#                         Stream download directly to files (experimental)
#                         (default: False)
#   --msgpack_purepython {True,False}
#                         Use less memory, but a bit more CPU power (default:
#                         False)
#   --fix_float_decimals {True,False}
#                         Fix content.json modification date float precision on
#                         verification (default: False)
#   --db_mode {speed,security}
#   --download_optional {manual,auto}
#   --coffeescript_compiler executable_path
#                         Coffeescript compiler for developing (default: None)
#   --tor {disable,enable,always}
#                         enable: Use only for Tor peers, always: Use Tor for
#                         every connection (default: enable)
#   --tor_controller ip:port
#                         Tor controller address (default: 127.0.0.1:9051)
#   --tor_proxy ip:port   Tor proxy address (default: 127.0.0.1:9050)
#   --tor_password password
#                         Tor controller password (default: None)
#   --tor_use_bridges     Use obfuscated bridge relays to avoid Tor block
#                         (default: False)
#   --tor_hs_limit limit  Maximum number of hidden services in Tor always mode
#                         (default: 10)
#   --tor_hs_port limit   Hidden service port in Tor always mode (default:
#                         15441)
#   --version             show program's version number and exit
#   --end                 Stop multi value argument parsing (default: False)
# 
# Action to perform:
#   {main,siteCreate,siteNeedFile,siteDownload,siteSign,sitePublish,siteVerify,siteCmd,dbRebuild,dbQuery,peerPing,peerGetFile,peerCmd,cryptSign,cryptVerify,cryptGetPrivatekey,getConfig,testConnection,testAnnounce}
#     main                Start UiServer and FileServer (default)
#     siteCreate          Create a new site
#     siteNeedFile        Get a file from site
#     siteDownload        Download a new site
#     siteSign            Update and sign content.json: address [privatekey]
#     sitePublish         Publish site to other peers: address
#     siteVerify          Verify site files using sha512: address
#     siteCmd             Execute a ZeroFrame API command on a site
#     dbRebuild           Rebuild site database cache
#     dbQuery             Query site sql cache
#     peerPing            Send Ping command to peer
#     peerGetFile         Request and print a file content from peer
#     peerCmd             Request and print a file content from peer
#     cryptSign           Sign message using Bitcoin private key
#     cryptVerify         Verify message using Bitcoin public address
#     cryptGetPrivatekey  Generate a privatekey from master seed
#     getConfig           Return json-encoded info
#     testConnection      Testing
#     testAnnounce        Testing
# 
# Zeroname plugin:
#   --bit_resolver address
#                         ZeroNet site to resolve .bit domains (default:
#                         1Name2NXVi1RDPDgf5617UoW7xA6YrhM9F)
# 
# OptionalManager plugin:
#   --optional_limit GB or free space %
#                         Limit total size of optional files (default: 10%)
#   --optional_limit_exclude_minsize MB
#                         Exclude files larger than this limit from optional
#                         size limit calculation (default: 20)
# 
# Bigfile plugin:
#   --autodownload_bigfile_size_limit MB
#                         Also download bigfiles smaller than this limit if help
#                         distribute option is checked (default: 1)
#   --bigfile_size_limit MB
#                         Maximum size of downloaded big files (default: False)
# 
# AnnounceShare plugin:
#   --working_shared_trackers_limit limit
#                         Stop discovering new shared trackers after this number
#                         of shared trackers reached (default: 5)
# 
# AnnounceLocal plugin:
#   --broadcast_port port
#                         UDP broadcasting port for local peer discovery
#                         (default: 1544)
# 
#--------------------------------------------------------------------------

# The preferred version is obviously the one with encryption enabled:
#
  nice -n15 python2 "$S_FP_SYMLINK_2_SELECTED_SERVER_INSTANCE"/zeronet.py --force_encryption  
#
# However, a more reliably working version is the one without the encryption enabled:
#
# nice -n15 python2 "$S_FP_SYMLINK_2_SELECTED_SERVER_INSTANCE"/zeronet.py 
#

# Just another command example:
#nice -n15 python2 "$S_FP_SYMLINK_2_SELECTED_SERVER_INSTANCE"/zeronet.py \
# --ui_ip 127.0.0.1  --ui_port 43110

func_assert_error_code_zero_t1 "$?" "068fae18-b3d7-497c-92b0-2262f04014e7"
#--------------------------------------------------------------------------
cd "$S_FP_ORIG"
#==========================================================================

