﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MikuMikuDance.XNA.MultiThread;
using MikuMikuDance.XNA.Debug;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace MikuMikuDanceXNADemo8
{
    /// <summary>
    /// テスト用スレッド
    /// GameThreadのテンプレートに独自クラスを指定すると、好きなクラスを通じて値の受け渡しができるよ。
    /// </summary>
    class TestThread : GameThread<object>
    {
        ITimeRuler m_timeRuler;
        //XBox用にコンストラクタを分ける
#if XBOX
        public TestThread(int HWThreadNum, Game game, ThreadManager manager, ITimeRuler timeRuler)
            :base(HWThreadNum, game, manager)
#else
        public TestThread(Game game, ThreadManager manager, ITimeRuler timeRuler)
            : base(game, manager)
#endif
        {
            //タイムルーラーだけフックしておく
            m_timeRuler = timeRuler;
        }
        public override void Update(GameTime gameTime)
        {
            double k;
            //計測してみる
            m_timeRuler.BeginMark(3, "TestThread", Color.Red);
            //重たい処理のつもり
            for (int i = 0; i < 10000; i++)
                k = Math.Sign(i);
            m_timeRuler.EndMark(3, "TestThread");
        }
    }
}
