using System;
using Microsoft.Xna.Framework;

namespace MikuMikuDance.XNA.Motion.MotionData
{
    /// <summary>
    /// xWFȐ
    /// </summary>
    /// <remarks>
    /// MMDŎgĂ(X)ĂxWFȐvZNXłB
    /// ̓xWFȐāAj[g@ŋߎvZĂ邾łB
    /// xWFȐ(http://musashi.or.tv/fontguide_doc3.htm)QlɂĂ炢܂
    /// </remarks>
    public struct BezierCurve
    {
        internal const float Epsilon = 1.0e-3f;
        /// <summary>
        /// xWFȐɗp_P
        /// </summary>
        public Vector2 v1;
        /// <summary>
        /// xWFȐɗp_2
        /// </summary>
        public Vector2 v2;
        /// <summary>
        /// isxڍsx擾
        /// </summary>
        /// <param name="Progress">isx</param>
        /// <returns>ڍsx</returns>
        public float Evaluate(float Progress)
        {
            //j[g@ɂߎ
            float t = MathHelper.Clamp(Progress, 0, 1);
            float dt;
            do
            {
                dt = -(fx(t) - Progress) / dfx(t);
                if (float.IsNaN(dt))
                    break;
                t += MathHelper.Clamp(dt, -1f, 1f);//啝Ɉړĕʂ̉ɓB̂h~p
            } while (Math.Abs(dt) > Epsilon);
            return MathHelper.Clamp(fy(t), 0f, 1f);//Ô߁A0-1̊ԂɎ܂悤ɂ
        }

        private float fy(float t)
        {
            //fy(t)=(1-t)^3*0+3*(1-t)^2*t*v1.y+3*(1-t)*t^2*v2.y+t^3*1
            return 3 * (1 - t) * (1 - t) * t * v1.Y + 3 * (1 - t) * t * t * v2.Y + t * t * t;
        }

        float fx(float t)
        {
            //fx(t)=(1-t)^3*0+3*(1-t)^2*t*v1.x+3*(1-t)*t^2*v2.x+t^3*1
            return 3 * (1 - t) * (1 - t) * t * v1.X + 3 * (1 - t) * t * t * v2.X + t * t * t;
        }
        float dfx(float t)
        {
            //dfx(t)/dt=-6(1-t)*t*v1.x+3(1-t)^2*v1.x-3t^2*v2.x+6(1-t)*t*v2.x+3t^2
            return -6 * (1 - t) * t * v1.X + 3 * (1 - t) * (1 - t) * v1.X
                - 3 * t * t * v2.X + 6 * (1 - t) * t * v2.X + 3 * t * t;
        }

    }
}