﻿using MikuMikuDance.XNA.Model;
using MikuMikuDance.XNA.Model.ModelData;

namespace MikuMikuDance.XNA.Motion
{
    /// <summary>
    /// モーショントラック種別
    /// </summary>
    public enum TrackType
    {
        /// <summary>
        /// 通常トラック
        /// </summary>
        NormalTrack,
        /// <summary>
        /// ベイク済みモーショントラック
        /// </summary>
        BakedTrack,
        /// <summary>
        /// マルチトラック
        /// </summary>
        MultiTrack,
    }
    
    /// <summary>
    /// モーショントラック抽象クラス
    /// </summary>
    interface MotionTrack
    {
        bool IsPlay { get; }
        bool IsEmpty { get; set; }
        bool IsLoopPlay { get; set; }

        void Start();
        void Stop();
        void Reset();
        void Seek(decimal frame);
        
        decimal NowFrame { get; set; }
        int NumRepeat { get; }
        long MaxFrame { get; set; }
        void ApplyMotion(MMDBoneManager mmdBone, MMDFaceManager mmdFace, ref QuatTransform transform, ref bool[] BoneUpdated);
        TrackType Type { get; }
        bool Reverse { get; set; }

        bool UpdateFrame(decimal FramePerSecond);

        void Smooth(MMDBoneManager BoneManager);
    }
}
