#region Using Xe[gg

using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework;

#endregion

namespace MikuMikuDance.XNA.Debug
{
    /// <summary>
    /// L[{[h͊֘Ã[eBeBNX(ɓ Y(HN:Ђ˂))
    /// </summary>
    public static class KeyboardUtils
    {
        #region tB[h

        /// <summary>
        /// ʏ̕ƃVtgL[ꂽ̕ێ镶yANX
        /// </summary>
        class CharPair
        {
            public CharPair( char normalChar, Nullable<char> shiftChar )
            {
                this.NormalChar = normalChar;
                this.ShiftChar = shiftChar;
            }

            public char NormalChar;
            public Nullable<char> ShiftChar;
        }

        // L[:Keys, l:CharPair
        static private Dictionary<Keys, CharPair> keyMap =
                                                    new Dictionary<Keys, CharPair>();

        #endregion

        /// <summary>
        /// L[񂩂當擾
        /// </summary>
        /// <param name="key">ꂽL[</param>
        /// <param name="shitKeyPressed">VtgL[Ă?</param>
        /// <param name="character">L[͂ϊꂽ</param>
        /// <returns>擾ꍇtrueԂ</returns>
        public static bool KeyToString( Keys key, bool shitKeyPressed,
                                                                    out char character )
        {
            bool result = false;
            character = ' ';
            CharPair charPair;

            if ( ( Keys.A <= key && key <= Keys.Z ) || key == Keys.Space )
            {
                // A`ZAXy[XL[͂̂܂ܕR[hƂĎgp
                character = ( shitKeyPressed ) ? (char)key : Char.ToLower( (char)key );
                result = true;
            }
            else if ( keyMap.TryGetValue( key, out charPair ) )
            {
                // ȊȌꍇKeyMap̏ɕϊ
                if ( !shitKeyPressed )
                {
                    character = charPair.NormalChar;
                    result = true;
                }
                else if ( charPair.ShiftChar.HasValue )
                {
                    character = charPair.ShiftChar.Value;
                    result = true;
                }
            }

            return result;
        }

        #region 

        static KeyboardUtils()
        {
            InitializeKeyMap();
        }

        /// <summary>
        /// pȊÕL[̕}bv̏
        /// </summary>
        /// <remarks>łUSL[{[hp̂̂錾Ă̂ŁA
        /// {L[{[hł͕ύXKv邩</remarks>
        static void InitializeKeyMap()
        {
            // pL[{[h̏ォ1
            AddKeyMap( Keys.OemTilde, "`~" );
            AddKeyMap( Keys.D1, "1!" );
            AddKeyMap( Keys.D2, "2@" );
            AddKeyMap( Keys.D3, "3#" );
            AddKeyMap( Keys.D4, "4$" );
            AddKeyMap( Keys.D5, "5%" );
            AddKeyMap( Keys.D6, "6^" );
            AddKeyMap( Keys.D7, "7&" );
            AddKeyMap( Keys.D8, "8*" );
            AddKeyMap( Keys.D9, "9(" );
            AddKeyMap( Keys.D0, "0)" );
            AddKeyMap( Keys.OemMinus, "-_" );
            AddKeyMap( Keys.OemPlus, "=+" );

            // pL[{[h̏ォ2
            AddKeyMap( Keys.OemOpenBrackets, "[{" );
            AddKeyMap( Keys.OemCloseBrackets, "]}" );
            AddKeyMap( Keys.OemPipe, "\\|" );

            // pL[{[h̏ォ3
            AddKeyMap( Keys.OemSemicolon, ";:" );
            AddKeyMap( Keys.OemQuotes, "'\"" );
            AddKeyMap( Keys.OemComma, ",<" );
            AddKeyMap( Keys.OemPeriod, ".>" );
            AddKeyMap( Keys.OemQuestion, "/?" );

            // pL[{[h̃L[pbh̃L[
            AddKeyMap( Keys.NumPad1, "1" );
            AddKeyMap( Keys.NumPad2, "2" );
            AddKeyMap( Keys.NumPad3, "3" );
            AddKeyMap( Keys.NumPad4, "4" );
            AddKeyMap( Keys.NumPad5, "5" );
            AddKeyMap( Keys.NumPad6, "6" );
            AddKeyMap( Keys.NumPad7, "7" );
            AddKeyMap( Keys.NumPad8, "8" );
            AddKeyMap( Keys.NumPad9, "9" );
            AddKeyMap( Keys.NumPad0, "0" );
            AddKeyMap( Keys.Add, "+" );
            AddKeyMap( Keys.Divide, "/" );
            AddKeyMap( Keys.Multiply, "*" );
            AddKeyMap( Keys.Subtract, "-" );
            AddKeyMap( Keys.Decimal, "." );
        }

        /// <summary>
        ///@L[{[h̃L[ƕ}bv̒ǉ
        /// </summary>
        /// <param name="key">L[{[h̃L[</param>
        /// <param name="charPair">
        /// AQ̏ꍇ̓VtgL[AL菇ԂɋLq</param>
        static void AddKeyMap( Keys key, string charPair )
        {
            char char1 = charPair[0];
            Nullable<char> char2 = null;
            if ( charPair.Length > 1 )
                char2 = charPair[1];

            keyMap.Add( key, new CharPair( char1, char2 ) );
        }

        #endregion

    }

}
