using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using MikuMikuDance.XNA;
using MikuMikuDance.XNA.Accessory;
using MikuMikuDance.XNA.Model;
using MikuMikuDance.XNA.Motion;
using MikuMikuDance.XNA.ShadowMap;
using MikuMikuDance.XNA.Model.ModelData;

namespace MikuMikuDanceXNADemo6
{
    /// <summary>
    /// MikuMikuDance for XNÃf
    /// ̃fł
    /// -MMDXł̃VhE}bv@
    /// Ă܂
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        //MikuMikuDance for XNA
        MikuMikuDanceXNA mmd;
        //MMDff[^
        MMDModel model;
        //MMD[Vf[^
        MMDBakedMotion motion;
        //MMDANZTf[^
        MMDAccessory stage, negi;
        //XN[}l[W
        ScreenManager screen;
        //VhE}bv}l[W
        PerspectiveShadowMap shadow;
        //LispShadowMap shadow;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            //foCXMMDX̕Kv𖞂Ă邩`FbN
            MikuMikuDanceXNA.InitialSetup(this, graphics, true);
            Content.RootDirectory = "Content";

        }

        protected override void Initialize()
        {
            base.Initialize();
        }

        /// <summary>
        /// LoadContent֐
        /// e탍[h͂Ń[hsĂƗǂ
        /// </summary>
        protected override void LoadContent()
        {
            //MikuMikuDanceXNA쐬
            mmd = new MikuMikuDanceXNA(this);
            //vWFNgContentɒǉĂMiku.pmdf[h
            //[hMikuMikuDanceXNA.LoadModel֐ōs
            //(ff[^͂ɂ܂肨؂肵܂B̃ft@CMITCZXKOł)
            model = mmd.LoadModel("Miku", this, QuatTransform.Identity);
            //ContentɒǉĂstage.x,negi.xANZT[h
            //(ANZTf[^͂ɂ܂肨؂肵܂B̃ft@CMITCZXKOł)
            stage = mmd.LoadAccessory("stage01", this, Matrix.Identity);//vZbTMikuMikuDanceANZTw
            negi = mmd.LoadAccessory("negi", this, Matrix.Identity);//vZbTMikuMikuDanceANZTw
            //ANZTpnegi-vac.vac[h
            MMD_VAC vac = mmd.LoadVAC("negi-vac");
            //fVACw肷邱ƂŎ(Matrixłw)
            model.SetAccessory(negi, vac);

            //[V[h
            motion = mmd.LoadBakedMotion("TrueMyHeartB");
            //f̃vC[Ăяo
            //[V0ԃgbNɃZbg
            model.Player.SetMotion(0, motion, true);

            //XN[}l[W̍쐬
            screen = new ScreenManager(GraphicsDevice);
            //MMDXɃXN[}l[Wo^
            mmd.ScreenManager = screen;
            //VhE}bv}l[W̍쐬
            //VhE}bv}l[W̓VhE}bv̊Ǘs
            shadow = new PerspectiveShadowMap(graphics.GraphicsDevice);
            //shadow = new LispShadowMap(graphics.GraphicsDevice);
            //MMDXɃVhE}bvo^
            mmd.ShadowMapManager = shadow;
            //f̃VhE\ON
            model.UseShadowMap = true;
            negi.UseShadowMap = true;
            stage.UseShadowMap = true;
        }

        /// <summary>
        /// UnloadContent֐
        /// A[hKvȕ͂ŃA[hs
        /// </summary>
        protected override void UnloadContent()
        {
        }

        /// <summary>
        /// Abvf[g֐
        /// t[`ȊÕR[hɋLq
        /// </summary>
        /// <param name="gameTime">݂̎Ԃ̃XibvVbg\IuWFNg</param>
        protected override void Update(GameTime gameTime)
        {
            //XBoxRg[[Back{^I
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();
            //L[{[hEscL[I
            if (Keyboard.GetState().IsKeyDown(Keys.Escape))
                this.Exit();
            //G^[L[orA{^Ƃ
            if (Keyboard.GetState().IsKeyDown(Keys.Enter) || GamePad.GetState(PlayerIndex.One).Buttons.A == ButtonState.Pressed)
            {
                //ݍĐłȂ
                if (!model.Player.IsPlay(0))
                {
                    model.Player.Reset(0);//Zbg
                    //0ԃgbNɃZbgĂ郂[VĐ
                    model.Player.Start(0, false);
                }
            }

            //f̍ĐDrawableGameComponentpĂ邽
            //XNAɂ莩ŏs

            //XNAUpdates
            base.Update(gameTime);
        }

        /// <summary>
        /// Draw֐
        /// t[`R[hɋLq
        /// </summary>
        /// <param name="gameTime">݂̎Ԃ̃XibvVbg\IuWFNg</param>
        protected override void Draw(GameTime gameTime)
        {
            //Drawł̓VhE}bvs(͎̏OōsKv)
            //{Iȗ
            //1.VhE}bvJn
            //2.VhE}bvp̕`MMDX3DIuWFNgyт̑[U[IuWFNgɂčs
            //3.VhE}bvI
            //4.ʏ̕`s

            //VhE}bv̊Jn
            shadow.BeginShadowMap(graphics.GraphicsDevice);
            GraphicsDevice.Clear(Color.White);
            //3DIuWFNg̃VhE}bv`
            mmd.DrawShadowMap(gameTime);

            //̑̃fɕtăVhE}bvꍇ͂ɋLq

            //VhE}bv̏I
            shadow.EndShadowMap(graphics.GraphicsDevice);
            //XN[}l[W̊Jn
            screen.Begin(graphics.GraphicsDevice);
            //ʂWhiteFŏ
            GraphicsDevice.Clear(Color.White);

            //fDrawableGameComponentpĂ邽
            //XNAɂ莩ŕ`悳

            //XNADraws
            base.Draw(gameTime);
            screen.End(graphics.GraphicsDevice);
            //spriteBatchŃV[rĂ̂Ōɖ߂R[h(SaveStateMode.SaveStategȂ̂͂ЂɂXNA(http://blogs.msdn.com/ito/archive/2007/03/13/spritebatch-part2.aspx)Q)
            //MMDXł͊efAANZT`OɎŐݒ肷R[hĂ̂ŁAŖ߂܂B
#if false
            GraphicsDevice.RenderState.DepthBufferEnable = true;
            GraphicsDevice.RenderState.AlphaTestEnable = false;
            GraphicsDevice.RenderState.AlphaBlendEnable = false;
            GraphicsDevice.SamplerStates[0].AddressU = TextureAddressMode.Wrap;
            GraphicsDevice.SamplerStates[0].AddressV = TextureAddressMode.Wrap;
#endif
        }
    }
}
