﻿using System;
using System.Collections.Generic;

namespace MikuMikuDance.XNA.Model.ModelData
{
    /// <summary>
    /// MMD用のボーンデータ
    /// </summary>
    public struct MMDBoneData
    {
        /// <summary>
        /// 対象となるボーンの名前
        /// </summary>
        public string Name;
        /// <summary>
        /// ボーンの種類
        /// </summary>
        public MMDBoneType BoneType;
        /// <summary>
        /// IKボーンの接続先(影響IKボーン)
        /// </summary>
        public UInt16 IKParentBoneIndex;

        /// <summary>
        /// ボーンのバインドポーズ行列
        /// </summary>
        public QuatTransform BindPose;
        /// <summary>
        /// ボーンのバインドポーズ逆行列
        /// </summary>
        public QuatTransform InverseBindPose;
        /// <summary>
        /// ボーンの親のボーンのインデックス情報
        /// </summary>
        /// <remarks>親が無い場合は-1</remarks>
        public int SkeletonHierarchy;
        /// <summary>
        /// ボーンのIK情報
        /// </summary>
        public List<MMDIKData> IK;
        /// <summary>
        /// IKデータを持っているかどうか
        /// </summary>
        public bool HasIK;
    }
}
