﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace MikuMikuDance.XNA.Stages
{
    /// <summary>
    /// ライトマネージャクラス
    /// </summary>
    public class MMDLightManager : GameComponent, IMMDLightManager
    {
        /// <summary>
        /// ライトアニメーションプレイヤー
        /// </summary>
        public LightAnimationPlayer Player { get; private set; }

        /// <summary>
        /// 環境光の色
        /// </summary>
        /// <remarks>MMDにおける照明色はこの項目が相当。MMDの表示設定と違い、rgb各要素が1少なくなるので注意</remarks>
        public Color AmbientLight { get; set; }

        /// <summary>
        /// キーライト
        /// </summary>
        /// <remarks>MMDの照明方向はこの項目が相当</remarks>
        public MMDLight KeyLight { get; set; }

        internal MMDLightManager(Game game)
            : base(game)
        {
            Player = new LightAnimationPlayer();
            AmbientLight = new Color(153, 153, 153);
            KeyLight = new MMDLight { Direction = new Vector3(-0.5f, -1f, -0.5f), Color = new Color(new Vector3(0.7f, 0.7f, 0.7f)), Type = LightType.DirectionalLight };
        }

        /// <summary>
        /// ライトUpdate
        /// </summary>
        /// <param name="gameTime">ゲームタイムオブジェクト</param>
        public override void Update(GameTime gameTime)
        {
            Player.Update(-1, false, this);
        }


    }
}
