﻿using System.Collections.Generic;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;
using Microsoft.Xna.Framework.Content;
using MikuMikuDance.XNA.Model.ModelData;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;

namespace MikuMikuDance.XNA.Model
{

    /// <summary>
    /// TypeWrite前のMMDModelクラス
    /// </summary>
    [ContentSerializerRuntimeType("MikuMikuDance.XNA.Model.ModelData.MMDModelData, MikuMikuDanceXNA")]
    public class MMDModelContent
    {
        /// <summary>
        /// XNA用モデルデータ
        /// </summary>
        public ModelContent ModelData;
        /// <summary>
        /// MMD用のボーン情報
        /// </summary>
        public MMDBoneData[] Bones;
        /// <summary>
        /// MMD用の表情情報
        /// </summary>
        public MMDSkinData[] Skins;
        /// <summary>
        /// 表情で用いる頂点数
        /// </summary>
        public int NumVertexForFace;
        /// <summary>
        /// MMD用の剛体情報
        /// </summary>
        public MMDRigid[] Rigids;
        /// <summary>
        /// MMD用のジョイント情報
        /// </summary>
        public MMDJoint[] Joints;
        /// <summary>
        /// シェーダに渡す表情頂点情報
        /// </summary>
        public Vector4[] FaceData;
        /// <summary>
        /// シェーダに表情頂点情報を渡す際に使用する頂点テクスチャサイズX
        /// </summary>
        public int FaceDataTextureSizeX;
        /// <summary>
        /// シェーダに渡す際に使用する頂点テクスチャサイズY
        /// </summary>
        public int FaceDataTextureSizeY;
        /// <summary>
        /// シェーダに表情頂点位置を渡す際に使用する頂点テクスチャサイズX
        /// </summary>
        public int FaceVertTextureSizeX;
        /// <summary>
        /// シェーダに表情頂点位置を渡す際に使用する頂点テクスチャサイズY
        /// </summary>
        public int FaceVertTextureSizeY;
        /// <summary>
        /// Zオーダー判定用
        /// </summary>
        public PartCenter[] PartCenters;
        /// <summary>
        /// パーツ中心Zソート法を使用するかどうか
        /// </summary>
        public bool UsePartCenterZSort;
    }
}
