﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;

namespace MikuMikuDance.XNA.Model.ModelData
{
    /// <summary>
    /// トゥーンテクスチャ管理クラス
    /// </summary>
    public class ToonTextures
    {
        /// <summary>
        /// トゥーンテクスチャ
        /// </summary>
        public Texture2D[] Toons;
        /// <summary>
        /// トゥーンテクスチャ(共用)
        /// </summary>
        internal static Texture2D[] s_Toons = null;
        internal Texture2D this[int i] { get { return s_Toons[i]; } }
        /// <summary>
        /// XNAのバグでシリアライズがうまくいかず、どうしても複数読み込みになるため
        /// これでできるだけメモリ消費を減らす
        /// </summary>
        /// <returns>初回読み込みかどうか</returns>
        internal bool Initialize()
        {
            if (s_Toons == null)
            {
                s_Toons = Toons;
                return true;
            }
            else
                Toons = s_Toons;
            return false;
        }
    }
}
