﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using Microsoft.Xna.Framework.Graphics;

namespace MikuMikuDance.XNA.Debug
{
    /// <summary>
    /// 速度検査用クラスのインターフェイス。
    /// 速度検査用のクラスはこれを継承して、MikuMikuDanceXNA.TimeRularにオブジェクトを入れると、中でマークしてもらえる。
    /// 元ネタはひにけにXNA(http://blogs.msdn.com/ito/archive/2008/12/27/debug-components-sample.aspx)より
    /// </summary>
    public interface ITimeRular
    {
        /// <summary>
        /// マーク開始
        /// </summary>
        /// <param name="markerName">マーカー名</param>
        /// <param name="color">色</param>
        void BeginMark(string markerName, Color color);
        /// <summary>
        /// マーク開始
        /// </summary>
        /// <param name="barIndex">バーインデックス</param>
        /// <param name="markerName">マーカー名</param>
        /// <param name="color">色</param>
        void BeginMark(int barIndex, string markerName, Color color);
        /// <summary>
        /// マーク終了
        /// </summary>
        /// <param name="markerName">マーカー名</param>
        void EndMark(string markerName);
        /// <summary>
        /// マーク終了
        /// </summary>
        /// <param name="barIndex">バーインデックス</param>
        /// <param name="markerName">マーカー名</param>
        void EndMark(int barIndex, string markerName);
    }
}
