﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using MikuMikuDance.XNA.Model;

namespace MikuMikuDance.XNA.Motion
{
    /// <summary>
    /// モーショントラック種別
    /// </summary>
    public enum TrackType
    {
        /// <summary>
        /// 通常トラック
        /// </summary>
        NormalTrack,
        /// <summary>
        /// ベイク済みモーショントラック
        /// </summary>
        BakedTrack,
    }
    
    /// <summary>
    /// モーショントラック抽象クラス
    /// </summary>
    interface MotionTrack
    {
        bool IsPlay { get; }
        bool IsEmpty { get; set; }
        bool IsLoopPlay { get; set; }

        void Start();
        void Stop();
        void Reset();

        decimal NowFrame { get; set; }
        int NumRepeat { get; }
        long MaxFrame { get; set; }
        void ApplyMotion(MMDBoneManager mmdBone, MMDFaceManager mmdFace, ref bool[] BoneUpdated);
        TrackType Type { get; }

        bool UpdateFrame(decimal FramePerSecond);
    }
}
