﻿using DWORD = System.UInt32;
namespace MikuMikuDance.XNA.Model.ModelData
{
    /// <summary>
    /// MMDのジョイント情報(内部用)
    /// </summary>
    public class MMDJoint
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; } // 諸データ：名称 // 右髪1(char*20)
        /// <summary>
        /// 剛体A
        /// </summary>
        public DWORD RigidBodyA { get; set; } // 諸データ：剛体A
        /// <summary>
        /// 剛体B
        /// </summary>
        public DWORD RigidBodyB { get; set; } // 諸データ：剛体B
        /// <summary>
        /// 位置(x, y, z)
        /// </summary>
        public float[] Position { get; set; } //float*3 諸データ：位置(x, y, z) // 諸データ：位置合せでも設定可
        /// <summary>
        /// 回転(rad(x), rad(y), rad(z))
        /// </summary>
        public float[] Rotation { get; set; } //float*3 諸データ：回転(rad(x), rad(y), rad(z))
        /// <summary>
        /// 移動制限1(x, y, z)
        /// </summary>
        public float[] ConstrainPosition1 { get; set; } //float*3 制限：移動1(x, y, z)
        /// <summary>
        /// 移動制限2(x, y, z)
        /// </summary>
        public float[] ConstrainPosition2 { get; set; } //float*3 制限：移動2(x, y, z)
        /// <summary>
        /// 回転制限1(rad(x), rad(y), rad(z))
        /// </summary>
        public float[] ConstrainRotation1 { get; set; } //float*3 制限：回転1(rad(x), rad(y), rad(z))
        /// <summary>
        /// 回転制限2(rad(x), rad(y), rad(z))
        /// </summary>
        public float[] ConstrainRotation2 { get; set; } //float*3 制限：回転2(rad(x), rad(y), rad(z))
        /// <summary>
        /// 平行移動に対するばねの戻る強さ：移動(x, y, z)
        /// </summary>
        public float[] SpringPosition { get; set; } //float*3 ばね：移動(x, y, z)
        /// <summary>
        /// 回転に対するばねの戻る強さ：回転(rad(x), rad(y), rad(z))
        /// </summary>
        public float[] SpringRotation { get; set; } //float*3 ばね：回転(rad(x), rad(y), rad(z))
    }
}
