﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MikuMikuDance.Model.Ver1;
using DWORD = System.UInt32;
using WORD = System.UInt16;
using Microsoft.Xna.Framework;

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// コンバート済み頂点データ
    /// </summary>
    struct MeshVertex
    {
        /// <summary>
        /// 頂点位置
        /// </summary>
        public Vector3 Pos; // x, y, z // 座標
        /// <summary>
        /// x,y,zの法線ベクトル
        /// </summary>
        public Vector3 NormalVector; // nx, ny, nz // 法線ベクトル
        /// <summary>
        /// UV座標(頂点UV)
        /// </summary>
        public Vector2 UV; // u, v // UV座標 // MMDは頂点UV
        /// <summary>
        /// ボーン番号
        /// </summary>
        /// <remarks>番号は1または2。モデル変形(頂点移動)時に影響</remarks>
        public WORD[] BoneNum; // ボーン番号1、番号2 // モデル変形(頂点移動)時に影響
        /// <summary>
        /// 影響度
        /// </summary>
        /// <remarks>ボーン1に与える影響度。min:0 max:100。ボーン2への影響度は、(100 - BoneWeight)</remarks>
        public byte BoneWeight; // ボーン1に与える影響度 // min:0 max:100 // ボーン2への影響度は、(100 - bone_weight)
        /// <summary>
        /// エッジフラグ
        /// </summary>
        /// <remarks>1:有効、0:エッジ無効</remarks>
        public byte EdgeFlag;
        /// <summary>
        /// 材質パレット番号
        /// </summary>
        public int PaletteNum;
        /*
        /// <summary>
        /// α値
        /// </summary>
        public float Alpha;
        /// <summary>
        /// 光沢
        /// </summary>
        public float Specularity;
        /// <summary>
        /// 使用するトゥーンbmp番号
        /// </summary>
        /// <remarks>使用する場合は0から9までの番号。使用しない場合は0xFF</remarks>
        public byte ToonIndex; // toon??.bmp // 0.bmp:0xFF, 1(01).bmp:0x00 ・・・ 10.bmp:0x09
        */
    }
    struct MeshMaterial
    {
        /// <summary>
        /// 面頂点数
        /// </summary>
        public DWORD FaceVertCount; // 面頂点数 // インデックスに変換する場合は、材質0から順に加算
        /// <summary>
        /// テクスチャファイル名
        /// </summary>
        public string TextureFileName; //20byte分char テクスチャファイル名 // 20バイトぎりぎりまで使える(終端の0x00は無くても動く)

        public const int NumPalette = 40;
        /// <summary>
        /// rgbの減衰色
        /// </summary>
        /// <remarks>アルファ値はここ</remarks>
        public Vector4[] DiffuseColorPalette; // dr, dg, db, alpha // 減衰色
        /// <summary>
        /// 環境色(ambient)(rgb)
        /// </summary>
        /// <remarks>トゥーン値はここ</remarks>
        public Vector4[] MirrorColorPalette; // mr, mg, mb,toon // 環境色(ambient)
        /// <summary>
        /// 光沢色(rgb)
        /// </summary>
        /// <remarks>SpecularPowerはここ</remarks>
        public Vector4[] SpecularColorPalette; // sr, sg, sb,spower // 光沢色
        
    }
    /// <summary>
    /// XNAビルド用のメッシュデータ
    /// </summary>
    class MMDMeshData
    {
        /// <summary>
        /// モデル名
        /// </summary>
        public string ModelName;
        /// <summary>
        /// 最適化済み頂点データ
        /// </summary>
        public MeshVertex[] Vertexes;
        /// <summary>
        /// 面リスト
        /// </summary>
        public WORD[] FaceVertexes;
        /// <summary>
        /// 材質リスト
        /// </summary>
        public MeshMaterial[] Materials;
        
        /// <summary>
        /// ボーンリスト。変換前のデータ参照そのままなので注意
        /// </summary>
        public ModelBone[] Bones;
        
    }
}
