/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion.geo;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * test case Vector3D 
 * @author nazo
 */
public class Vector3DTest {
    
    public Vector3DTest() {
    }
    
    @BeforeClass
    public static void setUpClass() {
    }
    
    @AfterClass
    public static void tearDownClass() {
    }
    
    @Before
    public void setUp() {
    }
    
    @After
    public void tearDown() {
    }

    @Test
    public void staticAndConstructorTest() {
        assertTrue(new Vector3D(1,0,0).equals(Vector3D.unitX));
        assertTrue(new Vector3D(0,1,0).equals(Vector3D.unitY));
        assertTrue(new Vector3D(0,0,1).equals(Vector3D.unitZ));
    }

    @Test
    public void singleCalculationTest(){
        Vector3D v=new Vector3D(1,2,3);

        assertTrue(new Vector3D(1,2,3).equals(v));
        assertTrue(new Vector3D(-1,-2,-3).equals(v.inverse()));
        assertEquals(14, v.norm2(),1e-9);
        assertEquals(Math.sqrt(14), v.norm(),1e-9);
    }

    @Test
    public void scalarCalculationTest(){
        Vector3D v=new Vector3D(1,2,3);

        assertTrue(new Vector3D( 1.5, 3.0,4.5).equals(v.times(1.5)));
        assertTrue(new Vector3D(-0.5,-1.0,-1.5).equals(v.divide(-2.0)));
    }

    @Test
    public void doubleCalculationTest(){
        Vector3D v=new Vector3D(1,2,3);

        assertTrue(new Vector3D(0,1,-1).equals(v.add(new Vector3D(-1,-1,-4))));
        assertTrue(new Vector3D(2,3,7).equals(v.sub(new Vector3D(-1,-1,-4))));
        assertEquals(1, v.times(Vector3D.unitX),1e-9);
        assertTrue(new Vector3D(2,-1,0).equals(v.cross(Vector3D.unitZ)));
        assertTrue(new Vector3D(3,2,-1).equals(v.rotate_vector(Vector3D.unitY,0)));
    }

    @Test
    public void conversionTest(){
        Vector3D v=new Vector3D(1,2,3);

        assertEquals("1.0,2.0,3.0",v.toString());
        assertArrayEquals(new double[]{1,2,3},v.toDouble(),1e-9);
    }
}
