/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion;

import jp.sourceforge.mmd.motion.geo.Vector3D;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author nazo
 */
public class MotionTest {
    private Motion m;
    public MotionTest() {
    }

    @Before
    public void setUp() {
        m=new Motion("test case");

        BonePose bp=new BonePose();
        bp.nameOfBone="center";
        bp.frame=0;
        m.put(bp);

        bp=new BonePose();
        bp.nameOfBone="center";
        bp.frame=20;
        bp.v=new Vector3D(1,0,0);
        m.put(bp);

        MorphPose mp=new MorphPose();
        mp.nameOfBone="ma";
        mp.frame=2;
        m.put(mp);
    
    }

    @After
    public void tearDown() {
        m=null;
    }

    @Test
    public void motionPropertyTest() {
        assertEquals("test case",m.getModelName());
        assertEquals(20,m.getMaxFrame());        
        assertNull(m.get("abc"));
        assertNull(m.get(1));
    }

    @Test
    public void bonePoseTest(){
        BonePose [] bps=m.get("center");
        assertEquals(2,bps.length);
        assertNotSame(bps[0], bps[1]);
        assertNotSame(bps[0], m.get("center")[0]);
        assertTrue(bps[0].equals(m.get("center")[0]));
        assertEquals(0,bps[0].frame);
        assertEquals(20,bps[1].frame);
        assertArrayEquals(new double []{1,0,0},m.get(20,"center").v.toDouble(),1e-9);
        assertArrayEquals(new double []{0.5,0,0},m.getInterporateBone(10,"center").v.toDouble(),1e-9);
    }

    @Test
    public void morphPoseTest(){
        assertEquals(2,m.getMorph("ma")[0].frame);
    }
}
