/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.MorphPose;
import jp.sourceforge.mmd.motion.Pose;

class MoveOnFrame {
    private int frame;
    protected TreeMap<String, BonePose> bonePoses;
    protected TreeMap<String, MorphPose> morphPoses;
    protected List<Pose<?>> otherPoses;

    public MoveOnFrame(int frame) {
        this.frame = frame;
        this.bonePoses = new TreeMap();
        this.morphPoses = new TreeMap();
        this.otherPoses = new ArrayList();
    }

    public int hashCode() {
        return this.frame;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoveOnFrame other = (MoveOnFrame)obj;
        return this.frame == other.frame;
    }

    public void put(Pose<?> p) {
        if (p instanceof BonePose) {
            this.bonePoses.put(p.nameOfBone, (BonePose)p);
        } else if (p instanceof MorphPose) {
            this.morphPoses.put(p.nameOfBone, (MorphPose)p);
        } else {
            this.otherPoses.add(p);
        }
    }

    public BonePose get(String s) {
        return this.bonePoses.get(s);
    }

    public MorphPose getMorph(String s) {
        return this.morphPoses.get(s);
    }

    public BonePose remove(String s) {
        return this.bonePoses.remove(s);
    }

    public MorphPose removeMorph(String s) {
        return this.morphPoses.remove(s);
    }

    public int size() {
        return this.bonePoses.size() + this.morphPoses.size() + this.otherPoses.size();
    }

    public Pose<?>[] toArray() {
        Pose[] ps = new Pose[this.size()];
        Iterator<Pose> ip = this.bonePoses.values().iterator();
        int i = 0;
        while (ip.hasNext()) {
            Pose pose = ip.next();
            ps[i] = pose.clone();
            ++i;
        }
        for (Pose pose : this.morphPoses.values()) {
            ps[i] = pose.clone();
            ++i;
        }
        for (Pose pose : this.otherPoses) {
            ps[i] = pose.clone();
            ++i;
        }
        return ps;
    }
}

