/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.CameraPose;
import jp.sourceforge.mmd.motion.LightPose;
import jp.sourceforge.mmd.motion.MorphPose;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.ShadowPose;
import jp.sourceforge.mmd.motion.geo.Vector3D;

class MoveOnBone<T extends Pose<T>> {
    private String nameOfBone;
    private TreeMap<Integer, T> frametopose;

    public MoveOnBone(String name) {
        this.nameOfBone = name;
        this.frametopose = new TreeMap();
    }

    public int hashCode() {
        return this.nameOfBone.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoveOnBone other = (MoveOnBone)obj;
        return this.nameOfBone.equals(other.nameOfBone);
    }

    public void put(T p) {
        this.frametopose.put(((Pose)p).frame, p);
    }

    public T get(int i) {
        return (T)((Pose)this.frametopose.get(i));
    }

    public T getInterporate(int frame) {
        Pose future;
        Pose pre;
        Map.Entry<Integer, T> e = this.frametopose.floorEntry(frame);
        if (e == null) {
            pre = null;
        } else {
            pre = (Pose)e.getValue();
            if (pre.frame == frame) {
                return (T)pre.clone();
            }
        }
        e = this.frametopose.higherEntry(frame);
        Pose pose = future = e == null ? null : (Pose)e.getValue();
        if (pre == null) {
            return (T)future.clone();
        }
        if (future == null) {
            return (T)pre.clone();
        }
        if (pre.equals(future)) {
            return (T)pre.clone();
        }
        int df = future.frame - pre.frame;
        if (pre instanceof BonePose) {
            BonePose bpre = (BonePose)pre;
            BonePose bfuture = (BonePose)future;
            BonePose bret = new BonePose();
            bret.frame = frame;
            bret.nameOfBone = new String(bpre.nameOfBone);
            double[] rv = new double[3];
            double[] prev = bpre.v.toDouble();
            double[] futurev = bfuture.v.toDouble();
            double t = (double)(frame - bpre.frame) / (double)df;
            double f = MoveOnBone.bezier(bfuture.interpX, t);
            rv[0] = futurev[0] * f + prev[0] * (1.0 - f);
            f = MoveOnBone.bezier(bfuture.interpY, t);
            rv[1] = futurev[1] * f + prev[1] * (1.0 - f);
            f = MoveOnBone.bezier(bfuture.interpZ, t);
            rv[2] = futurev[2] * f + prev[2] * (1.0 - f);
            bret.v = new Vector3D(rv);
            f = MoveOnBone.bezier(bfuture.interpR, t);
            bret.mr = bfuture.mr.times(bpre.mr.inverse()).power(f).times(bpre.mr);
            return (T)bret;
        }
        if (pre instanceof CameraPose) {
            CameraPose cpre = (CameraPose)pre;
            CameraPose cfuture = (CameraPose)future;
            CameraPose cret = new CameraPose();
            cret.frame = frame;
            cret.perspective = cpre.perspective;
            double[] rv = new double[3];
            double[] prev = cpre.v.toDouble();
            double[] futurev = cfuture.v.toDouble();
            double t = (double)(frame - cpre.frame) / (double)df;
            double f = MoveOnBone.bezier(cfuture.interpX, t);
            rv[0] = futurev[0] * f + prev[0] * (1.0 - f);
            f = MoveOnBone.bezier(cfuture.interpY, t);
            rv[1] = futurev[1] * f + prev[1] * (1.0 - f);
            f = MoveOnBone.bezier(cfuture.interpZ, t);
            rv[2] = futurev[2] * f + prev[2] * (1.0 - f);
            cret.v = new Vector3D(rv);
            f = MoveOnBone.bezier(cfuture.interpRange, t);
            cret.range = (float)((double)cfuture.range * f + (double)cpre.range * (1.0 - f));
            f = MoveOnBone.bezier(cfuture.interpProjection, t);
            cret.angle = (int)((double)cfuture.angle * f + (double)cpre.angle * (1.0 - f));
            return (T)cret;
        }
        if (pre instanceof MorphPose) {
            MorphPose mpre = (MorphPose)pre;
            MorphPose mfuture = (MorphPose)future;
            MorphPose mret = new MorphPose();
            mret.frame = frame;
            mret.nameOfBone = new String(mpre.nameOfBone);
            double f = (double)(frame - mpre.frame) / (double)df;
            mret.factor = (float)((double)mpre.factor * (1.0 - f) + (double)mfuture.factor * f);
            return (T)mret;
        }
        if (pre instanceof LightPose) {
            LightPose lpre = (LightPose)pre;
            LightPose lfuture = (LightPose)future;
            LightPose lret = new LightPose();
            lret.frame = frame;
            double f = (double)(frame - lpre.frame) / (double)df;
            lret.v = lpre.v.times(1.0 - f).add(lfuture.v.times(f));
            lret.rgb[0] = (float)((double)lpre.rgb[0] * (1.0 - f) + (double)lfuture.rgb[0] * f);
            lret.rgb[1] = (float)((double)lpre.rgb[1] * (1.0 - f) + (double)lfuture.rgb[1] * f);
            lret.rgb[2] = (float)((double)lpre.rgb[2] * (1.0 - f) + (double)lfuture.rgb[2] * f);
            return (T)lret;
        }
        if (pre instanceof ShadowPose) {
            ShadowPose spre = (ShadowPose)pre;
            ShadowPose sfuture = (ShadowPose)future;
            ShadowPose sret = new ShadowPose();
            sret.frame = frame;
            sret.mode = spre.mode;
            double f = (double)(frame - spre.frame) / (double)df;
            sret.distance = (float)((double)spre.distance * (1.0 - f) + (double)sfuture.distance * f);
            return (T)sret;
        }
        return (T)pre.clone();
    }

    public static double bezier(byte[] interp, double t) {
        double tt;
        double f = 0.5;
        double fi = 1.0 - f;
        for (double df = 0.5; df > 1.0E-10 && t != (tt = (((double)interp[0] * fi + (double)interp[2] * f) * fi * 3.0 / 127.0 + f * f) * f); df *= 0.5) {
            f = t < tt ? (f -= df) : (f += df);
            fi = 1.0 - f;
        }
        return (((double)interp[1] * fi + (double)interp[3] * f) * fi * 3.0 / 127.0 + f * f) * f;
    }

    public T remove(int i) {
        return (T)((Pose)this.frametopose.remove(i));
    }

    public int size() {
        return this.frametopose.size();
    }

    public Integer[] gc() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Pose pre = null;
        Pose pre2 = null;
        for (Pose p : this.frametopose.values()) {
            if (pre == null) {
                pre = p;
                continue;
            }
            if (pre2 == null) {
                pre2 = pre;
                pre = p;
                continue;
            }
            if (pre2.equals(p) && pre.equals(p)) {
                list.add(pre.frame);
            } else {
                pre2 = pre;
            }
            pre = p;
        }
        for (Integer i : list) {
            this.frametopose.remove(i);
        }
        return list.toArray(new Integer[list.size()]);
    }

    public T[] toArray(T[] poses) {
        Iterator<T> ip = this.frametopose.values().iterator();
        int i = 0;
        while (ip.hasNext()) {
            Pose p = (Pose)ip.next();
            poses[i] = p.clone();
            ++i;
        }
        return poses;
    }

    public String toCSV() {
        StringBuilder ret = new StringBuilder(512);
        for (Pose p : this.frametopose.values()) {
            ret.append(p.toCSV());
        }
        return ret.toString();
    }

    byte[] toVMD() {
        ArrayList<byte[]> al = new ArrayList<byte[]>();
        int length = 0;
        for (Pose p : this.frametopose.values()) {
            byte[] a = p.toVMD();
            al.add(a);
            length += a.length;
        }
        ByteBuffer ret = ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
        for (byte[] line : al) {
            ret.put(line);
        }
        return ret.array();
    }
}

