/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ParseStage;
import jp.sfjp.mikutoga.pmd.parser.PmdBasicHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdBoneHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdMorphHandler;
import jp.sfjp.mikutoga.pmx.BoneFlags;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;
import jp.sourceforge.mmd.motion.model.Morph;

public class PmdFileHander
implements PmdBoneHandler,
PmdBasicHandler,
PmdMorphHandler {
    protected static Vector3D absoluteZ = Vector3D.unitZ;
    protected Model model;
    protected Bone bone;
    protected Morph morph;
    protected ArrayList<String> idToName;
    protected TreeMap<Integer, Integer> childToParent;
    protected TreeMap<Integer, Integer> parentToTail;

    public PmdFileHander(Model model) {
        this.model = model;
    }

    @Override
    public void pmdParseStart() {
        this.bone = null;
        this.morph = null;
    }

    @Override
    public void pmdHeaderInfo(byte[] header) throws MmdFormatException {
        if (header[0] != 80 || header[1] != 109 || header[2] != 100) {
            throw new MmdFormatException("Not PMD file.");
        }
    }

    @Override
    public void pmdModelInfo(String modelName, String description) {
        this.model.setName(modelName);
    }

    @Override
    public void loopStart(ParseStage stage, int loops) {
        if (stage == PmdBoneHandler.BONE_LIST) {
            this.idToName = new ArrayList();
            this.childToParent = new TreeMap();
            this.parentToTail = new TreeMap();
        }
    }

    @Override
    public void pmdBoneInfo(String boneName, byte boneKind) {
        this.bone = new Bone(this.model);
        this.bone.name = boneName;
        this.idToName.add(boneName);
        this.bone.id = this.idToName.size() - 1;
        short opvr = (short)(BoneFlags.ROTATE.encode() | BoneFlags.OP.encode() | BoneFlags.VISIBLE.encode());
        switch (boneKind) {
            case 0: {
                this.bone.flags = opvr;
                break;
            }
            case 1: {
                this.bone.flags = (short)(BoneFlags.MOVE.encode() | opvr);
                break;
            }
            case 2: {
                this.bone.flags = (short)(BoneFlags.IK.encode() | opvr);
                break;
            }
            case 3: {
                this.bone.flags = opvr;
                break;
            }
            case 4: {
                this.bone.flags = opvr;
                break;
            }
            case 5: {
                this.bone.flags = (short)(BoneFlags.ROTATE_LINK.encode() | BoneFlags.LINK_FLAG.encode() | opvr);
                break;
            }
            case 6: {
                this.bone.flags = (short)(BoneFlags.MOVE.encode() | opvr);
                break;
            }
            case 7: {
                this.bone.flags = 0;
                break;
            }
            case 8: {
                this.bone.flags = (short)(BoneFlags.AXIS_ROTATE.encode() | opvr);
                break;
            }
            case 9: {
                this.bone.flags = opvr;
            }
        }
    }

    @Override
    public void pmdBoneLink(int parentId, int tailId, int ikId) {
        if (parentId != 65535) {
            this.childToParent.put(this.idToName.size() - 1, parentId);
        }
        if (tailId != 65535) {
            this.parentToTail.put(this.idToName.size() - 1, tailId);
        }
    }

    @Override
    public void pmdBonePosition(float xPos, float yPos, float zPos) {
        this.bone.gv = new Vector3D(xPos, yPos, zPos);
    }

    @Override
    public void pmdIKInfo(int boneId, int targetId, int depth, float weight) {
    }

    @Override
    public void pmdIKChainInfo(int childId) {
    }

    @Override
    public void pmdBoneGroupInfo(String groupName) {
    }

    @Override
    public void pmdGroupedBoneInfo(int boneId, int groupId) {
    }

    @Override
    public void loopNext(ParseStage stage) {
        if (this.bone != null) {
            this.model.put(this.bone);
        }
        this.bone = null;
    }

    @Override
    public void loopEnd(ParseStage stage) {
        if (stage == PmdBoneHandler.BONE_LIST) {
            for (Map.Entry<Integer, Integer> e : this.childToParent.entrySet()) {
                Bone child = this.model.get(this.idToName.get(e.getKey()));
                this.model.get(this.idToName.get(e.getValue())).addChild(child);
            }
            for (Map.Entry<Integer, Integer> e : this.parentToTail.entrySet()) {
                double norm;
                Vector3D arrow;
                String name = this.idToName.get(e.getKey());
                Bone parent = this.model.get(name);
                String tail = this.idToName.get(e.getValue());
                if ((BoneFlags.AXIS_ROTATE.encode() & parent.flags) > 0) {
                    arrow = this.model.get(tail).getPos().sub(parent.getPos());
                    norm = arrow.norm();
                    if (!(norm > 0.0)) continue;
                    parent.limitRot = arrow.divide(norm);
                    continue;
                }
                if (!name.matches("((\u5de6|\u53f3)(\u8155|\u3072\u3058|\u624b\u9996)|.*(\u89aa|\u4eba|\u4e2d|\u85ac|\u5c0f)\u6307.*)")) continue;
                arrow = this.model.get(tail).getPos().sub(parent.getPos());
                norm = (arrow = arrow.sub(absoluteZ.times(arrow.times(absoluteZ)))).norm();
                if (!(norm > 0.0)) continue;
                parent.setInicialLocalCoordinate(arrow.divide(norm), absoluteZ);
            }
        }
    }

    @Override
    public void pmdParseEnd(boolean hasMoreData) {
    }

    @Override
    public void pmdMorphInfo(String morphName, byte morphType) throws MmdFormatException {
        this.morph = new Morph(this.model);
        this.morph.setName(morphName);
        this.model.put(this.morph);
    }

    @Override
    public void pmdMorphVertexInfo(int serialId, float xPos, float yPos, float zPos) throws MmdFormatException {
    }

    @Override
    public void pmdMorphOrderInfo(int morphId) throws MmdFormatException {
    }
}

