/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ParseStage;
import jp.sfjp.mikutoga.pmd.parser.PmdBasicHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdBoneHandler;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

public class PmdFileHander
implements PmdBoneHandler,
PmdBasicHandler {
    protected static Vector3D absoluteZ = Vector3D.unitZ;
    protected Model model;
    protected Bone bone;
    protected ArrayList<String> idToName;
    protected TreeMap<Integer, Integer> childToParent;
    protected TreeMap<Integer, Integer> parentToTail;

    public PmdFileHander(Model model) {
        this.model = model;
    }

    public void pmdParseStart() {
        this.bone = null;
    }

    public void pmdHeaderInfo(byte[] header) throws MmdFormatException {
        if (header[0] != 80 || header[1] != 109 || header[2] != 100) {
            throw new MmdFormatException("Not PMD file.");
        }
    }

    public void pmdModelInfo(String modelName, String description) {
        this.model.setName(modelName);
    }

    public void loopStart(ParseStage stage, int loops) {
        if (stage == PmdBoneHandler.BONE_LIST) {
            this.idToName = new ArrayList();
            this.childToParent = new TreeMap();
            this.parentToTail = new TreeMap();
        }
    }

    public void pmdBoneInfo(String boneName, byte boneKind) {
        this.bone = new Bone(this.model);
        this.bone.name = boneName;
        this.idToName.add(boneName);
        switch (boneKind) {
            case 8: {
                this.bone.limitRot = new Vector3D();
            }
        }
    }

    public void pmdBoneLink(int parentId, int tailId, int ikId) {
        if (parentId == 65535) {
            this.bone.parent = null;
        } else {
            this.childToParent.put(this.idToName.size() - 1, parentId);
        }
        if (tailId != 65535) {
            this.parentToTail.put(this.idToName.size() - 1, tailId);
        }
    }

    public void pmdBonePosition(float xPos, float yPos, float zPos) {
        this.bone.gv = new Vector3D(xPos, yPos, zPos);
        this.bone.mr = new Matrix();
        this.bone.ini_mr = new Matrix();
    }

    public void pmdIKInfo(int boneId, int targetId, int depth, float weight) {
    }

    public void pmdIKChainInfo(int childId) {
    }

    public void pmdBoneGroupInfo(String groupName) {
    }

    public void pmdGroupedBoneInfo(int boneId, int groupId) {
    }

    public void loopNext(ParseStage stage) {
        if (this.bone != null) {
            this.model.put(this.bone);
        }
        this.bone = null;
    }

    public void loopEnd(ParseStage stage) {
        if (stage == PmdBoneHandler.BONE_LIST) {
            for (Map.Entry<Integer, Integer> e : this.childToParent.entrySet()) {
                Bone child = this.model.get(this.idToName.get(e.getKey()));
                child.parent = this.idToName.get(e.getValue());
                this.model.get(child.parent).addChild(child);
            }
            for (Map.Entry<Integer, Integer> e : this.parentToTail.entrySet()) {
                double norm;
                Vector3D arrow;
                String name = this.idToName.get(e.getKey());
                Bone parent = this.model.get(name);
                String tail = this.idToName.get(e.getValue());
                if (parent.limitRot != null) {
                    arrow = this.model.get(tail).getPos().sub(parent.getPos());
                    norm = arrow.norm();
                    if (!(norm > 0.0)) continue;
                    parent.limitRot = arrow.divide(norm);
                    continue;
                }
                if (!name.matches("((\u5de6|\u53f3)(\u8155|\u3072\u3058|\u624b\u9996)|.*(\u89aa|\u4eba|\u4e2d|\u85ac|\u5c0f)\u6307.*)")) continue;
                arrow = this.model.get(tail).getPos().sub(parent.getPos());
                norm = (arrow = arrow.sub(absoluteZ.times(arrow.times(absoluteZ)))).norm();
                if (!(norm > 0.0)) continue;
                parent.mr = new Matrix(arrow.divide(norm), absoluteZ);
                parent.ini_mr = new Matrix(parent.mr);
            }
        }
    }

    public void pmdParseEnd(boolean hasMoreData) {
    }
}

