/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;

public class MidiResolver {
    private Sequence midiSeq;
    private Track[] tracks;
    private int reso;
    private int tempo = 500000;
    private ArrayList<MidiEvent>[] channelList;

    public MidiResolver(File f) {
        try {
            this.midiSeq = MidiSystem.getSequence(f);
            this.tracks = this.midiSeq.getTracks();
            this.reso = this.midiSeq.getResolution();
            this.channelList = new ArrayList[16];
            for (int i = 0; i < this.tracks.length; ++i) {
                MidiEvent me;
                Track t = this.tracks[i];
                for (int j = 0; j < t.size() && (me = t.get(j)) != null; ++j) {
                    MetaMessage mem;
                    MidiMessage mm = me.getMessage();
                    if (mm == null) continue;
                    if (mm instanceof ShortMessage) {
                        ShortMessage sm = (ShortMessage)mm;
                        int ch = sm.getChannel();
                        if (this.channelList[ch] == null) {
                            this.channelList[ch] = new ArrayList();
                        }
                        this.channelList[ch].add(me);
                        continue;
                    }
                    if (!(mm instanceof MetaMessage) || (mem = (MetaMessage)mm).getType() != 81) continue;
                    byte[] tempB = mem.getData();
                    this.tempo = ((tempB[0] & 0xFF) << 16) + ((tempB[1] & 0xFF) << 8) + (tempB[2] & 0xFF);
                }
            }
        }
        catch (InvalidMidiDataException ex) {
            Logger.getLogger(MidiResolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MidiResolver.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public MidiEvent[] getChannelMessage(int ch) {
        if (this.channelList[ch] == null) {
            return null;
        }
        return this.channelList[ch].toArray(new MidiEvent[this.channelList[ch].size()]);
    }

    public Sequence getMidiSeq() {
        return this.midiSeq;
    }

    public int getReso() {
        return this.reso;
    }

    public int getTemp() {
        return this.tempo;
    }

    public void add(MidiResolver mr) {
        Track t = this.tracks[0];
        long length = this.midiSeq.getTickLength();
        if (length % (long)this.reso > 0L) {
            length = (length / (long)this.reso + 1L) * (long)this.reso;
        }
        for (int ch = 0; ch < 16; ++ch) {
            MidiEvent[] mms = mr.getChannelMessage(ch);
            if (mms == null) continue;
            if (this.channelList[ch] == null) {
                this.channelList[ch] = new ArrayList();
            }
            for (MidiEvent me : mms) {
                me.setTick(me.getTick() + length);
                t.add(me);
                this.channelList[ch].add(me);
            }
        }
    }

    public void write(OutputStream os) throws IOException {
        MidiSystem.write(this.midiSeq, 0, os);
    }
}

