/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd.parser;

import java.io.IOException;
import java.io.InputStream;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.pmd.parser.PmdJointHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdParserExt2;
import jp.sfjp.mikutoga.pmd.parser.PmdRigidHandler;
import jp.sfjp.mikutoga.pmd.parser.PmdUnifiedHandler;

public class PmdParserExt3
extends PmdParserExt2 {
    private PmdRigidHandler rigidHandler = PmdUnifiedHandler.EMPTY;
    private PmdJointHandler jointHandler = PmdUnifiedHandler.EMPTY;

    public PmdParserExt3(InputStream source) {
        super(source);
    }

    public void setRigidHandler(PmdRigidHandler handler) {
        this.rigidHandler = handler == null ? PmdUnifiedHandler.EMPTY : handler;
    }

    public void setJointHandler(PmdJointHandler handler) {
        this.jointHandler = handler == null ? PmdUnifiedHandler.EMPTY : handler;
    }

    @Override
    protected void parseBody() throws IOException, MmdFormatException {
        super.parseBody();
        if (this.hasMore()) {
            this.parseRigidList();
            this.parseJointList();
        }
    }

    private void parseRigidList() throws IOException, MmdFormatException {
        int rigidNum = this.parseLeInt();
        this.rigidHandler.loopStart(PmdRigidHandler.RIGID_LIST, rigidNum);
        for (int ct = 0; ct < rigidNum; ++ct) {
            String rigidName = this.parsePmdText(20);
            this.rigidHandler.pmdRigidName(rigidName);
            int linkedBoneId = this.parseLeUShortAsInt();
            int rigidGroupId = this.parseUByteAsInt();
            short collisionMap = this.parseLeShort();
            this.rigidHandler.pmdRigidInfo(rigidGroupId, linkedBoneId);
            this.parseRigidGeom();
            this.parseRigidDynamics();
            byte behaveType = this.parseByte();
            this.rigidHandler.pmdRigidBehavior(behaveType, collisionMap);
            this.rigidHandler.loopNext(PmdRigidHandler.RIGID_LIST);
        }
        this.rigidHandler.loopEnd(PmdRigidHandler.RIGID_LIST);
    }

    private void parseRigidGeom() throws IOException, MmdFormatException {
        byte shapeType = this.parseByte();
        float width = this.parseLeFloat();
        float height = this.parseLeFloat();
        float depth = this.parseLeFloat();
        this.rigidHandler.pmdRigidShape(shapeType, width, height, depth);
        float posX = this.parseLeFloat();
        float posY = this.parseLeFloat();
        float posZ = this.parseLeFloat();
        this.rigidHandler.pmdRigidPosition(posX, posY, posZ);
        float rotX = this.parseLeFloat();
        float rotY = this.parseLeFloat();
        float rotZ = this.parseLeFloat();
        this.rigidHandler.pmdRigidRotation(rotX, rotY, rotZ);
    }

    private void parseRigidDynamics() throws IOException, MmdFormatException {
        float mass = this.parseLeFloat();
        float dampingPos = this.parseLeFloat();
        float dampingRot = this.parseLeFloat();
        float restitution = this.parseLeFloat();
        float friction = this.parseLeFloat();
        this.rigidHandler.pmdRigidPhysics(mass, dampingPos, dampingRot, restitution, friction);
    }

    private void parseJointList() throws IOException, MmdFormatException {
        int jointNum = this.parseLeInt();
        this.jointHandler.loopStart(PmdJointHandler.JOINT_LIST, jointNum);
        for (int ct = 0; ct < jointNum; ++ct) {
            String jointName = this.parsePmdText(20);
            this.jointHandler.pmdJointName(jointName);
            int rigidIdA = this.parseLeInt();
            int rigidIdB = this.parseLeInt();
            this.jointHandler.pmdJointLink(rigidIdA, rigidIdB);
            this.parseJointGeom();
            this.parseJointLimit();
            this.parseJointElastic();
            this.jointHandler.loopNext(PmdJointHandler.JOINT_LIST);
        }
        this.jointHandler.loopEnd(PmdJointHandler.JOINT_LIST);
    }

    private void parseJointGeom() throws IOException, MmdFormatException {
        float posX = this.parseLeFloat();
        float posY = this.parseLeFloat();
        float posZ = this.parseLeFloat();
        this.jointHandler.pmdJointPosition(posX, posY, posZ);
        float rotX = this.parseLeFloat();
        float rotY = this.parseLeFloat();
        float rotZ = this.parseLeFloat();
        this.jointHandler.pmdJointRotation(rotX, rotY, rotZ);
    }

    private void parseJointLimit() throws IOException, MmdFormatException {
        float posXlim1 = this.parseLeFloat();
        float posYlim1 = this.parseLeFloat();
        float posZlim1 = this.parseLeFloat();
        float posXlim2 = this.parseLeFloat();
        float posYlim2 = this.parseLeFloat();
        float posZlim2 = this.parseLeFloat();
        this.jointHandler.pmdPositionLimit(posXlim1, posXlim2, posYlim1, posYlim2, posZlim1, posZlim2);
        float rotXlim1 = this.parseLeFloat();
        float rotYlim1 = this.parseLeFloat();
        float rotZlim1 = this.parseLeFloat();
        float rotXlim2 = this.parseLeFloat();
        float rotYlim2 = this.parseLeFloat();
        float rotZlim2 = this.parseLeFloat();
        this.jointHandler.pmdRotationLimit(rotXlim1, rotXlim2, rotYlim1, rotYlim2, rotZlim1, rotZlim2);
    }

    private void parseJointElastic() throws IOException, MmdFormatException {
        float elasticPosX = this.parseLeFloat();
        float elasticPosY = this.parseLeFloat();
        float elasticPosZ = this.parseLeFloat();
        this.jointHandler.pmdElasticPosition(elasticPosX, elasticPosY, elasticPosZ);
        float elasticRotX = this.parseLeFloat();
        float elasticRotY = this.parseLeFloat();
        float elasticRotZ = this.parseLeFloat();
        this.jointHandler.pmdElasticRotation(elasticRotX, elasticRotY, elasticRotZ);
    }
}

