/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.ik_solver;

import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;

public class IKSolver {
    public static final int RLIMIT_LIMITED = 128;
    public static final int RLIMIT_NOGlobalR = 64;
    public static final int RLIMIT_NOX = 3;
    public static final int RLIMIT_NOY = 12;
    public static final int RLIMIT_NOZ = 48;
    protected static final double limit_sine = Math.sqrt(0.5);
    protected Bone[] bones;
    protected int[] limits;

    public void setBones(Bone[] arms) {
        this.bones = new Bone[arms.length];
        this.limits = new int[arms.length];
        for (int i = 0; i < arms.length; ++i) {
            this.bones[i] = arms[i];
            if (arms[i].getLimitRot() == null) continue;
            this.limits[i] = 128;
        }
    }

    public void setLimits(int index, int flags) {
        this.limits[index] = flags;
    }

    public int getLimits(int index) {
        return this.limits[index];
    }

    public void solve(Vector3D target) {
        Matrix gmr = null;
        if ((this.limits[0] & 0x40) > 0) {
            gmr = this.bones[0].getGMatrix();
        }
        for (int i = 0; i < 100; ++i) {
            for (int k = 1; k < this.bones.length; ++k) {
                double co;
                double sine;
                Vector3D center = this.bones[k].getPos();
                Vector3D tr = target.sub(center);
                Vector3D ta = this.bones[0].getPos().sub(center);
                double norm = tr.norm();
                if (norm == 0.0) continue;
                Vector3D ntr = tr.divide(norm);
                norm = ta.norm();
                if (norm == 0.0) continue;
                Vector3D nta = ta.divide(norm);
                Vector3D rt = nta.cross(ntr);
                if (this.limits[k] > 0) {
                    Vector3D axis;
                    if ((this.limits[k] & 0x80) > 0) {
                        axis = this.bones[k].getLimitRot();
                        sine = rt.times(axis);
                        rt = axis.times(sine);
                        co = Math.sqrt(1.0 - sine * sine);
                    } else {
                        if ((this.limits[k] & 3) > 0) {
                            axis = this.bones[k].getLx();
                            co = rt.times(axis);
                            rt = rt.sub(axis.times(co));
                        }
                        if ((this.limits[k] & 0xC) > 0) {
                            axis = this.bones[k].getLy();
                            co = rt.times(axis);
                            rt = rt.sub(axis.times(co));
                        }
                        if ((this.limits[k] & 0x30) > 0) {
                            axis = this.bones[k].getLz();
                            co = rt.times(axis);
                            rt = rt.sub(axis.times(co));
                        }
                        co = (sine = rt.norm()) > 1.0 ? 0.0 : Math.sqrt(1.0 - sine * sine);
                    }
                } else {
                    sine = rt.norm();
                    if (sine > limit_sine) {
                        rt = rt.times(limit_sine / sine);
                        co = limit_sine;
                    } else {
                        co = ntr.times(nta);
                    }
                }
                if (sine == 0.0) continue;
                this.bones[k].rotate(rt, co);
            }
        }
        if ((this.limits[0] & 0x40) > 0) {
            this.bones[0].rotateToG(gmr);
        }
    }
}

