/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ParseStage;
import jp.sfjp.mikutoga.vmd.parser.VmdBasicHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdBoolHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdCameraHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdLightingHandler;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.BooleanPose;
import jp.sourceforge.mmd.motion.CameraPose;
import jp.sourceforge.mmd.motion.LightPose;
import jp.sourceforge.mmd.motion.MorphPose;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.ShadowPose;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;

public class VMDMotionHander
implements VmdBasicHandler,
VmdCameraHandler,
VmdLightingHandler,
VmdBoolHandler {
    private final Motion motion;
    private BonePose bonePose;
    private CameraPose cameraPose;
    private LightPose lightPose;
    private ShadowPose shadowPose;
    private BooleanPose booleanPose;
    private int offset;

    public VMDMotionHander(Motion motion, int offset) {
        this.motion = motion;
        this.offset = offset;
    }

    @Override
    public void vmdParseStart() throws MmdFormatException {
        this.bonePose = null;
        this.cameraPose = null;
        this.lightPose = null;
        this.shadowPose = null;
        this.booleanPose = null;
    }

    @Override
    public void vmdHeaderInfo(byte[] header) throws MmdFormatException {
        String a = new String(header, 0, 26);
        if (!a.startsWith("Vocaloid Motion Data 0002")) {
            throw new MmdFormatException("Header error", 0L);
        }
    }

    @Override
    public void vmdModelName(String modelName) throws MmdFormatException {
        this.motion.setModelName(modelName);
    }

    @Override
    public void loopStart(ParseStage stage, int loops) throws MmdFormatException {
    }

    @Override
    public void vmdBoneMotion(String boneName, int keyFrameNo) throws MmdFormatException {
        this.bonePose = new BonePose();
        this.bonePose.frame = keyFrameNo + this.offset;
        this.bonePose.nameOfBone = boneName;
    }

    @Override
    public void vmdBonePosition(float x, float y, float z) throws MmdFormatException {
        this.bonePose.v = new Vector3D(x, y, z);
    }

    @Override
    public void vmdBoneRotationQt(float qx, float qy, float qz, float qw) throws MmdFormatException {
        this.bonePose.mr = Matrix.rotationQ(qx, qy, qz, qw);
    }

    @Override
    public void vmdBoneIntpltXpos(byte xP1x, byte xP1y, byte xP2x, byte xP2y) throws MmdFormatException {
        this.bonePose.interpX = new byte[]{xP1x, xP1y, xP2x, xP2y};
    }

    @Override
    public void vmdBoneIntpltYpos(byte yP1x, byte yP1y, byte yP2x, byte yP2y) throws MmdFormatException {
        this.bonePose.interpY = new byte[]{yP1x, yP1y, yP2x, yP2y};
    }

    @Override
    public void vmdBoneIntpltZpos(byte zP1x, byte zP1y, byte zP2x, byte zP2y) throws MmdFormatException {
        this.bonePose.interpZ = new byte[]{zP1x, zP1y, zP2x, zP2y};
    }

    @Override
    public void vmdBoneIntpltRot(byte rP1x, byte rP1y, byte rP2x, byte rP2y) throws MmdFormatException {
        this.bonePose.interpR = new byte[]{rP1x, rP1y, rP2x, rP2y};
    }

    @Override
    public void vmdMorphMotion(String morphName, int keyFrameNo, float f) throws MmdFormatException {
        MorphPose p = new MorphPose();
        p.frame = keyFrameNo + this.offset;
        p.nameOfBone = morphName;
        p.factor = f;
        this.motion.put(p);
    }

    @Override
    public void loopNext(ParseStage stage) throws MmdFormatException {
        if (this.bonePose != null) {
            this.motion.put(this.bonePose);
            this.bonePose = null;
        }
        if (this.cameraPose != null) {
            this.motion.put(this.cameraPose);
            this.cameraPose = null;
        }
        if (this.lightPose != null) {
            this.motion.put(this.lightPose);
            this.lightPose = null;
        }
        if (this.shadowPose != null) {
            this.motion.put(this.shadowPose);
            this.shadowPose = null;
        }
        if (this.booleanPose != null) {
            this.motion.put(this.booleanPose);
            this.booleanPose = null;
        }
    }

    @Override
    public void loopEnd(ParseStage stage) throws MmdFormatException {
    }

    @Override
    public void vmdParseEnd(boolean hasMoreData) throws MmdFormatException {
    }

    @Override
    public void vmdCameraMotion(int keyFrameNo) throws MmdFormatException {
        this.cameraPose = new CameraPose();
        this.cameraPose.frame = keyFrameNo + this.offset;
    }

    @Override
    public void vmdCameraRange(float range) throws MmdFormatException {
        this.cameraPose.range = range;
    }

    @Override
    public void vmdCameraPosition(float xPos, float yPos, float zPos) throws MmdFormatException {
        this.cameraPose.v = new Vector3D(xPos, yPos, zPos);
    }

    @Override
    public void vmdCameraRotation(float latitude, float longitude, float roll) throws MmdFormatException {
        this.cameraPose.lat = latitude;
        this.cameraPose.lon = longitude;
        this.cameraPose.roll = roll;
    }

    @Override
    public void vmdCameraProjection(int angle, boolean hasPerspective) throws MmdFormatException {
        this.cameraPose.angle = angle;
        this.cameraPose.perspective = hasPerspective;
    }

    @Override
    public void vmdCameraIntpltXpos(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        this.cameraPose.interpX = new byte[]{p1x, p1y, p2x, p2y};
    }

    @Override
    public void vmdCameraIntpltYpos(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        this.cameraPose.interpY = new byte[]{p1x, p1y, p2x, p2y};
    }

    @Override
    public void vmdCameraIntpltZpos(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        this.cameraPose.interpZ = new byte[]{p1x, p1y, p2x, p2y};
    }

    @Override
    public void vmdCameraIntpltRotation(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        this.cameraPose.interpR = new byte[]{p1x, p1y, p2x, p2y};
    }

    @Override
    public void vmdCameraIntpltRange(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        this.cameraPose.interpRange = new byte[]{p1x, p1y, p2x, p2y};
    }

    @Override
    public void vmdCameraIntpltProjection(byte p1x, byte p1y, byte p2x, byte p2y) throws MmdFormatException {
        this.cameraPose.interpProjection = new byte[]{p1x, p1y, p2x, p2y};
    }

    @Override
    public void vmdLuminousMotion(int keyFrameNo) throws MmdFormatException {
        this.lightPose = new LightPose();
        this.lightPose.frame = keyFrameNo + this.offset;
    }

    @Override
    public void vmdLuminousColor(float rVal, float gVal, float bVal) throws MmdFormatException {
        this.lightPose.rgb = new float[]{rVal, gVal, bVal};
    }

    @Override
    public void vmdLuminousDirection(float xVec, float yVec, float zVec) throws MmdFormatException {
        this.lightPose.v = new Vector3D(xVec, yVec, zVec);
    }

    @Override
    public void vmdShadowMotion(int keyFrameNo) throws MmdFormatException {
        this.shadowPose = new ShadowPose();
        this.shadowPose.frame = keyFrameNo + this.offset;
    }

    @Override
    public void vmdShadowMode(byte shadowMode) throws MmdFormatException {
        this.shadowPose.mode = shadowMode;
    }

    @Override
    public void vmdShadowScopeRaw(float shadowScope) throws MmdFormatException {
        this.shadowPose.distance = shadowScope;
    }

    @Override
    public void vmdModelSight(boolean show, int keyFrameNo) throws MmdFormatException {
        this.booleanPose = new BooleanPose();
        this.booleanPose.show = show;
        this.booleanPose.frame = keyFrameNo + this.offset;
    }

    @Override
    public void vmdIkSwitch(String boneName, boolean validIk, int keyFrameNo) throws MmdFormatException {
        if (this.booleanPose == null) {
            this.booleanPose = new BooleanPose();
            this.booleanPose.frame = keyFrameNo + this.offset;
        }
        this.booleanPose.iks.put(boneName, validIk);
    }
}

