/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DB(x) (x)
*/
#define DB(x)

#include "config.h"

#include "ww_texturetile.h"

typedef struct _WwTexturetilePrivate WwTexturetilePrivate;
struct _WwTexturetilePrivate {
	gboolean dispose_has_run;

	gdouble west;
	gdouble east;
	gdouble south;
	gdouble north;
};

#define WW_TEXTURETILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), WW_TYPE_TEXTURETILE, WwTexturetilePrivate))

static WwTextureClass *parent_class = NULL;

static void ww_texturetile_class_init (WwTexturetileClass * klass);
static void ww_texturetile_init (WwTexturetile * object);
static void ww_texturetile_finalize (GObject * object);
static void ww_texturetile_dispose (GObject * object);
static GObject *ww_texturetile_constructor (GType type, guint n_props, GObjectConstructParam * props);

GType
ww_texturetile_get_type (void)
{
	static GType type = 0;

	if (type == 0) {
		static const GTypeInfo info = {
			sizeof (WwTexturetileClass),
			NULL,				/* base_init */
			NULL,				/* base_finalize */
			(GClassInitFunc) ww_texturetile_class_init,
			NULL,				/* class_finalize */
			NULL,				/* class_data */
			sizeof (WwTexturetile),
			0,					/* n_preallocs */
			(GInstanceInitFunc) ww_texturetile_init
		};

		type = g_type_register_static (WW_TYPE_TEXTURE, "WwTexturetile", &info, 0);
	}

	return type;
}

static void
ww_texturetile_class_init (WwTexturetileClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	WwTextureClass *wwtexture_class = WW_TEXTURE_CLASS (klass);

	g_print ("ww_texturetile_class_init:c:%p:\n", klass);

	g_type_class_add_private (klass, sizeof (WwTexturetilePrivate));

	parent_class = g_type_class_peek_parent (klass);
	object_class->constructor = ww_texturetile_constructor;
	object_class->finalize = ww_texturetile_finalize;
	object_class->dispose = ww_texturetile_dispose;
}

static void
ww_texturetile_init (WwTexturetile * self)
{
	WwTexturetilePrivate *priv = WW_TEXTURETILE_GET_PRIVATE (self);
	/*
	   g_print ("ww_texturetile_init:o:%p:\n", self);
	 */
	priv->dispose_has_run = FALSE;

	priv->west = 0.0;
	priv->east = 0.0;
	priv->south = 0.0;
	priv->north = 0.0;
}

static void
ww_texturetile_dispose (GObject * obj)
{
	WwTexturetile *self = WW_TEXTURETILE (obj);
	WwTexturetilePrivate *priv = WW_TEXTURETILE_GET_PRIVATE (self);
	/*
	   g_print ("ww_texturetile_dispose\n");
	 */

	if (priv->dispose_has_run) {
		return;
	}
	priv->dispose_has_run = TRUE;
	/*
	   g_object_unref(self->***);
	 */
	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

static void
ww_texturetile_finalize (GObject * obj)
{
	/*
	WwTexturetile *self = WW_TEXTURETILE (obj);
	WwTexturetilePrivate *priv = WW_TEXTURETILE_GET_PRIVATE (self);
	   g_print ("ww_texturetile_finalize\n");
	 */
	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

static GObject *
ww_texturetile_constructor (GType type, guint n_props, GObjectConstructParam * props)
{
	GObject *object;
	GObjectClass *object_class = G_OBJECT_CLASS (parent_class);
	/*
	   g_print ("ww_texturetile_constructor\n");
	 */
	object = object_class->constructor (type, n_props, props);

	return object;
}

WwTexturetile *
ww_texturetile_new (void)
{
	GObject *object;

	object = g_object_new (WW_TYPE_TEXTURETILE, NULL);

    /*
	g_print ("ww_texturetile_new:o:%p\n", object);
    */

	return WW_TEXTURETILE (object);
}

/********************************************************************/

void
ww_texturetile_set_coordinate (WwTexturetile * texture, gdouble west, gdouble south, gdouble east, gdouble north)
{
	WwTexturetilePrivate *priv = WW_TEXTURETILE_GET_PRIVATE (texture);

	priv->west = west;
	priv->east = east;
	priv->south = south;
	priv->north = north;
}

void
ww_texturetile_get_coordinate (WwTexturetile * texture, gdouble * west, gdouble * south, gdouble * east, gdouble * north)
{
	WwTexturetilePrivate *priv = WW_TEXTURETILE_GET_PRIVATE (texture);

	*west = priv->west;
	*east = priv->east;
	*south = priv->south;
	*north = priv->north;


}
