/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DB(x) (x)
*/
#define DB(x)

#include <stdlib.h>

#include <gtk/gtkgl.h>
#include <GL/gl.h>
#include <GL/glext.h>

#include "config.h"

#include "ww_texture.h"
#include "glarea.h"

typedef struct _WwTexturePrivate WwTexturePrivate;
struct _WwTexturePrivate {
	gboolean dispose_has_run;

	guint t_num;
};

#define WW_TEXTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), WW_TYPE_TEXTURE, WwTexturePrivate))

static GObjectClass *parent_class = NULL;

static void ww_texture_class_init (WwTextureClass * klass);
static void ww_texture_init (WwTexture * object);
static void ww_texture_finalize (GObject * object);
static void ww_texture_dispose (GObject * object);
static GObject *ww_texture_constructor (GType type, guint n_props, GObjectConstructParam * props);

GType
ww_texture_get_type (void)
{
	static GType type = 0;

	if (type == 0) {
		static const GTypeInfo info = {
			sizeof (WwTextureClass),
			NULL,				/* base_init */
			NULL,				/* base_finalize */
			(GClassInitFunc) ww_texture_class_init,
			NULL,				/* class_finalize */
			NULL,				/* class_data */
			sizeof (WwTexture),
			0,					/* n_preallocs */
			(GInstanceInitFunc) ww_texture_init
		};

		type = g_type_register_static (G_TYPE_OBJECT, "WwTexture", &info, 0);
	}

	return type;
}

static void
ww_texture_class_init (WwTextureClass * klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	/*
	   g_print ("ww_texture_class_init:c:%p:\n", klass);
	 */
	g_type_class_add_private (klass, sizeof (WwTexturePrivate));

	parent_class = g_type_class_peek_parent (klass);
	object_class->constructor = ww_texture_constructor;
	object_class->finalize = ww_texture_finalize;
	object_class->dispose = ww_texture_dispose;
}

static void
ww_texture_init (WwTexture * self)
{
	WwTexturePrivate *priv = WW_TEXTURE_GET_PRIVATE (self);
	/*
	   g_print ("ww_texture_init:o:%p:\n", self);
	 */
	priv->dispose_has_run = FALSE;

	priv->t_num = 0;
}

static void
ww_texture_dispose (GObject * obj)
{
	WwTexture *self = WW_TEXTURE (obj);
	WwTexturePrivate *priv = WW_TEXTURE_GET_PRIVATE (self);
	/*
	   g_print ("ww_texture_dispose\n");
	 */

	if (priv->dispose_has_run) {
		return;
	}
	priv->dispose_has_run = TRUE;
	/*
	   g_object_unref(self->***);
	 */
	G_OBJECT_CLASS (parent_class)->dispose (obj);
}

/**********************/

static gboolean
idle_func_texture_free (gpointer data)
{
	guint *t_num = (guint *) data;
	/*
	   g_print ("idle_func_texture_free\n");
	 */
	glarea_gl_begin ();
	glDeleteTextures (1, t_num);
	glarea_gl_end ();

	g_free (t_num);

	return FALSE;				/* FALSE を返すと単発で終了 */
}

static void
ww_texture_finalize (GObject * obj)
{
	WwTexture *self = WW_TEXTURE (obj);
	WwTexturePrivate *priv = WW_TEXTURE_GET_PRIVATE (self);
	guint *t_num;
	/*
	   g_print ("ww_texture_finalize\n");
	 */

	t_num = g_new (guint, 1);
	*t_num = priv->t_num;

	/* テクスチャーの開放を色々なスレッドでしようとすると面倒なので、idle ループ内でする。  */
	/* 全ての OpenGL 関係を idle ループ内でする。 */
	g_idle_add (idle_func_texture_free, t_num);

	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

/**********************/

static GObject *
ww_texture_constructor (GType type, guint n_props, GObjectConstructParam * props)
{
	GObject *object;
	GObjectClass *object_class = G_OBJECT_CLASS (parent_class);
	/*
	   g_print ("ww_texture_constructor\n");
	 */
	object = object_class->constructor (type, n_props, props);

	return object;
}

WwTexture *
ww_texture_new (void)
{
	GObject *object;

	object = g_object_new (WW_TYPE_TEXTURE, NULL);
	/*
	   g_print ("ww_texture_new:o:%p\n", object);
	 */
	return WW_TEXTURE (object);
}

/********************************************************************/

void
ww_texture_set_id (WwTexture * texture, guint id)
{
	WwTexturePrivate *priv;

	priv = WW_TEXTURE_GET_PRIVATE (texture);

	priv->t_num = id;
}

WwTexture *
ww_texture_copy (WwTexture * texture)
{
	g_object_ref (texture);

	return texture;
}

gboolean
ww_texture_bind (WwTexture * texture)
{
	WwTexturePrivate *priv;

/*
    g_print("ww_texture_bind\n");
    */

	if (texture == NULL) {
		glBindTexture (GL_TEXTURE_2D, 0);

		return FALSE;
	}

	priv = WW_TEXTURE_GET_PRIVATE (texture);

	if (priv->t_num == 0) {
		glBindTexture (GL_TEXTURE_2D, 0);

		return FALSE;

	} else {
		glBindTexture (GL_TEXTURE_2D, priv->t_num);

		return TRUE;
	}
}

gboolean
ww_texture_is_ok (WwTexture * texture)
{
	WwTexturePrivate *priv;
	gboolean is_ok;

	priv = WW_TEXTURE_GET_PRIVATE (texture);

	if (priv->t_num == 0) {
		is_ok = FALSE;
	} else {
		is_ok = TRUE;
	}

	return is_ok;
}
