/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_OBJECT_H__
#define __WW_OBJECT_H__

#include <gtk/gtk.h>

#include "ww_data.h"

G_BEGIN_DECLS
#define WW_TYPE_OBJECT                 (ww_object_get_type ())
#define WW_OBJECT(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_OBJECT, WwObject))
#define WW_OBJECT_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_OBJECT, WwObjectClass))
#define WW_IS_OBJECT(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_OBJECT))
#define WW_IS_OBJECT_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_OBJECT))
#define WW_OBJECT_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_OBJECT, WwObjectClass))
typedef struct _WwObject WwObject;
typedef struct _WwObjectClass WwObjectClass;

struct _WwObject {
	GObject parent;

		/*****/
	WwObject *wwparent;
	gboolean is_on;
	gboolean visible;

		/*****/
	gchar *name;
	gchar *extended_information_abstract;
	gchar *extended_information_tool_bar_image;

	/* attribute */
	gboolean show_at_startup;
};

struct _WwObjectClass {
	GObjectClass parent_class;

	void (*set_on) (WwObject * self, gboolean is_on);
	void (*update) (WwObject * self);
	void (*render) (WwObject * self);
	void (*set_layermanager_menu) (WwObject * self, GtkTreeIter * iter_parent);
	void (*debug_print) (WwObject * self);
};

GType ww_object_get_type (void);

WwObject *ww_object_new (void);

void ww_object_set_on (WwObject * self, gboolean is_on);
gboolean ww_object_get_on (WwObject * self);
void ww_object_update (WwObject * self);
void ww_object_render (WwObject * self);
gchar *ww_object_get_path (WwObject * self);

void ww_object_set_layermanager_menu (WwObject * obj, GtkTreeIter * iter_parent);

void ww_object_debug_print (WwObject * obj);


G_END_DECLS
#endif /* __WW_OBJECT_H__ */
